/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.model.FileRevision;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.revision.diff.DiffRevisionsInfo;
import com.cenqua.crucible.revision.diff.unified.DiffDirectory;
import com.cenqua.crucible.revision.source.PatchSource;
import com.cenqua.crucible.upload.UploadItem;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Patch {
    private Integer id;
    private Review review;
    private UploadItem uploadItem;
    private List<FileRevision> fileRevisions;
    private List<DiffRevisionsInfo> diffRevisionsInfos;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Review getReview() {
        return this.review;
    }

    public void setReview(Review review) {
        this.review = review;
    }

    public UploadItem getUploadItem() {
        return this.uploadItem;
    }

    public void setUploadItem(UploadItem uploadItem) throws IOException {
        this.uploadItem = uploadItem;
        this.fileRevisions = new LinkedList<FileRevision>();
    }

    public List<FileRevision> getFileRevisions() {
        return this.fileRevisions;
    }

    public void setFileRevisions(List<FileRevision> fileRevisions) {
        this.fileRevisions = fileRevisions;
    }

    public FileRevision getFileRevisionFromDRI(DiffRevisionsInfo dri) {
        for (FileRevision fr : this.fileRevisions) {
            if (!fr.getRevIdent().equals(Patch.getRevIdent(dri))) continue;
            return fr;
        }
        return null;
    }

    private static String getRevIdent(DiffRevisionsInfo dri) {
        String ft = dri.isAdded() || dri.isChanged() || dri.isCopied() ? ":T" : ":F";
        return dri.getIndex() + ft;
    }

    public DiffRevisionsInfo getDiffRevisionInfo(FileRevision fileRevision) throws IOException {
        for (DiffRevisionsInfo dri : this.getDiffRevisions()) {
            if (!fileRevision.getRevIdent().equals(Patch.getRevIdent(dri))) continue;
            return dri;
        }
        return null;
    }

    public List<DiffRevisionsInfo> getDiffRevisions() throws IOException {
        if (this.diffRevisionsInfos == null) {
            DiffDirectory dir = new DiffDirectory(this.getPatchFile());
            this.diffRevisionsInfos = dir.list();
        }
        return this.diffRevisionsInfos;
    }

    public File getPatchFile() {
        return this.uploadItem.getItemFile();
    }

    public void createFileRevisions() throws IOException {
        List<DiffRevisionsInfo> files = this.getDiffRevisions();
        for (DiffRevisionsInfo dri : files) {
            if (dri.getFromRevisionName() != null) {
                this.fileRevisions.add(PatchSource.makeFromRevision(this, dri));
            }
            if (dri.getToRevisionName() == null) continue;
            this.fileRevisions.add(PatchSource.makeToRevision(this, dri));
        }
    }
}

