/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.fisheye.util.VariableSubstituter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActionManager {
    public static final ActionManager INSTANCE = new ActionManager();
    private String smtpServer = "mail";
    private String cruAddress = "crucible@cenqua.com";

    public String getSmtpServer() {
        return this.smtpServer;
    }

    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    public String getCruAddress() {
        return this.cruAddress;
    }

    public void setCruAddress(String cruAddress) {
        this.cruAddress = cruAddress;
    }

    public void doAction(String action, CrucibleUser user, Review review) {
        if (action.startsWith("markReviewed")) {
            this.markReviewed(review);
        }
        if (action.startsWith("cleanup")) {
            review.cleanupAllComments();
        }
        if (action.startsWith("mailto")) {
            this.mailto(action.substring("mailto:".length()), user, review);
        }
        if (action.startsWith("script")) {
            this.runScript(action.substring("script:".length()), user, review);
        }
    }

    private void markReviewed(Review review) {
        List frxs = FRXManager.getFRXs(review, null, false);
        for (FileRevisionExtraInfo frx : frxs) {
            frx.setReviewed(new Integer(0));
        }
    }

    private Map getReviewVars(Review review) {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("permaId", review.getPermaId());
        vars.put("title", review.getName());
        vars.put("author", review.getAuthor().getUserName());
        vars.put("moderator", review.getModerator().getUserName());
        return vars;
    }

    private void mailto(String params, CrucibleUser user, Review review) {
        String message = params.substring(params.indexOf(47) + 1);
        Map vars = this.getReviewVars(review);
        vars.put("user", user.getDisplayName());
        message = VariableSubstituter.substituteRefs((CharSequence)message, vars);
        if (params.startsWith("${author}")) {
            NotificationManager.INSTANCE.noteGeneralMsg(review, user, review.getAuthor(), message);
        } else if (params.startsWith("${moderator}")) {
            NotificationManager.INSTANCE.noteGeneralMsg(review, user, review.getModerator(), message);
        } else if (params.startsWith("${reviewers}")) {
            for (CrucibleUser reviewer : review.getActiveReviewers()) {
                NotificationManager.INSTANCE.noteGeneralMsg(review, user, reviewer, message);
            }
        }
    }

    private void runScript(String params, CrucibleUser user, Review review) {
        Map vars = this.getReviewVars(review);
        vars.put("user", user.getDisplayName());
        params = VariableSubstituter.substituteRefs((CharSequence)params, vars);
        try {
            Runtime.getRuntime().exec(params);
            LogManager.log("Excecuted script " + params);
        }
        catch (IOException ioe) {
            LogManager.log("Couldn't run " + params + " because I got: " + ioe.getMessage());
        }
    }
}

