/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.FileRevision;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.upload.UploadItem;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchManager {
    private static Session session() {
        return HibernateUtil.currentSession();
    }

    public static Patch createPatch(UploadItem upload) throws IOException {
        Patch p = PatchManager.findPatch(upload);
        if (p != null) {
            return p;
        }
        p = new Patch();
        PatchManager.session().save((Object)p);
        p.setUploadItem(upload);
        p.createFileRevisions();
        return p;
    }

    public static Patch getPatchById(Integer id) {
        return (Patch)PatchManager.session().get(Patch.class, (Serializable)id);
    }

    private static Patch findPatch(UploadItem upload) {
        Query q = PatchManager.session().createQuery("select patch from Patch patch where patch.uploadItem = :upload");
        q.setEntity("upload", (Object)upload);
        return (Patch)q.uniqueResult();
    }

    public static Patch findPatch(FileRevision rev) {
        Query q = PatchManager.session().createQuery("select patch from Patch patch join patch.fileRevisions rev where rev = :rev");
        q.setEntity("rev", (Object)rev);
        return (Patch)q.uniqueResult();
    }

    public static List<Patch> findReviewPatches(Review review) {
        Query q = PatchManager.session().createQuery("select patch from Patch patch where review = :review");
        q.setEntity("review", (Object)review);
        return Collections.checkedList(new LinkedList(q.list()), Patch.class);
    }
}

