/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers.impl;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.ReviewPermaId;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="projectManager")
public class DefaultProjectManager
implements ProjectManager,
InitializingBean {
    public static final String DEFAULT_PROJECT_KEY = "CR";

    @Autowired
    public DefaultProjectManager(SessionFactory sessionFactory) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() {
        HibernateUtil.beginTransaction();
        try {
            this.getDefaultProject();
            HibernateUtil.commitTransaction();
        }
        finally {
            HibernateUtil.closeSession();
        }
    }

    private Session session() {
        return HibernateUtil.currentSession();
    }

    @Override
    public List<Project> getAllProjects() {
        List projects = this.session().createQuery("from Project").list();
        return Collections.checkedList(new LinkedList(projects), Project.class);
    }

    @Override
    public Project getProjectById(int id) {
        return (Project)this.session().get(Project.class, (Serializable)Integer.valueOf(id));
    }

    @Override
    public boolean deleteProject(Project p) {
        if (!this.getDefaultProject().equals(p) && this.getReviewsInProject(p).isEmpty()) {
            this.session().delete((Object)p);
            return true;
        }
        return false;
    }

    private List getReviewsInProject(Project p) {
        Query q = this.session().createQuery("from Review where project = :project");
        q.setEntity("project", (Object)p);
        return q.list();
    }

    @Override
    public void changeProjectKey(Project p, String newKey) {
        Query q = this.session().createQuery("delete ReviewPermaId where key = :newKey");
        q.setString("newKey", newKey);
        q.executeUpdate();
        q = this.session().createQuery("from ReviewPermaId where key = :oldkey");
        q.setString("oldkey", p.getKey());
        List oldpids = q.list();
        for (Object oldpid : oldpids) {
            ReviewPermaId permaId = (ReviewPermaId)oldpid;
            ReviewPermaId newpid = new ReviewPermaId(permaId.getReview(), newKey, permaId.getPermaIdKey().getNumber());
            permaId.getReview().getPermaIdHistory().add(newpid);
        }
        p.setKey(newKey);
    }

    @Override
    public Project createProject(String name, String key) {
        Project p = this.getProjectByKey(key);
        if (p == null) {
            p = new Project();
            p.setKey(key);
            p.setName(name);
            p.setPermissionScheme(PermissionManager.getDefaultPermissionScheme());
            this.session().save((Object)p);
        }
        return p;
    }

    @Override
    public Project getProjectByKey(String key) {
        Query q = this.session().createQuery("from Project where lower(key) = :key");
        q.setString("key", key.toLowerCase(Locale.US));
        return (Project)q.uniqueResult();
    }

    @Override
    public Project getDefaultProject() {
        Project p = this.getProjectById(1);
        if (p == null) {
            return this.createProject("Default Project", DEFAULT_PROJECT_KEY);
        }
        return p;
    }

    @Override
    public int getNextSeqNo(Project p) {
        Query q = this.session().createQuery("select max(number)+1 from ReviewPermaId where key = :key");
        q.setString("key", p.getKey());
        Integer v = (Integer)q.uniqueResult();
        return v == null ? 1 : v;
    }

    @Override
    public List<String> getAllProjectKeys() {
        LinkedHashSet result = new LinkedHashSet();
        Query q1 = this.session().createQuery("select distinct p.key from Project p");
        result.addAll(q1.list());
        Query q2 = this.session().createQuery("select distinct p.permaIdKey.key from ReviewPermaId p");
        result.addAll(q2.list());
        return new ArrayList<String>(result);
    }
}

