/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.diff.unified;

import com.cenqua.crucible.revision.diff.DiffRevisionsInfo;
import com.cenqua.crucible.revision.diff.Directory;
import com.cenqua.crucible.revision.diff.unified.DiffMatcher;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.io.LineReader;
import com.cenqua.fisheye.io.ReaderLineReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffDirectory
implements Directory {
    private final File patchFile;
    private static final String WORKING_COPY = "working copy";
    private DiffMatcher diffMatcher = new DiffMatcher();

    public DiffDirectory(File patchFile) {
        this.patchFile = patchFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DiffRevisionsInfo> list() throws IOException {
        LinkedList<DiffRevisionsInfo> linkedList;
        FileReader fr = null;
        try {
            String line;
            fr = new FileReader(this.patchFile);
            ReaderLineReader reader = new ReaderLineReader(LineReader.Mode.MODE_MIXED, new BufferedReader(fr));
            LinkedList<DiffRevisionsInfo> files = new LinkedList<DiffRevisionsInfo>();
            int idx = 0;
            while ((line = reader.readLine()) != null) {
                DiffMatcher.Header toHeader;
                String nextLine;
                DiffMatcher.Header fromHeader = this.diffMatcher.matchHeader(true, line);
                if (fromHeader == null || (nextLine = reader.readLine()) == null || (toHeader = this.diffMatcher.matchHeader(false, nextLine)) == null || (nextLine = reader.readLine()) == null) continue;
                DiffMatcher.Section section = this.diffMatcher.matchSection(nextLine);
                DiffRevisionsInfo dri = this.processMatches(fromHeader, toHeader, section);
                dri.setIndex(idx++);
                files.add(dri);
            }
            linkedList = files;
        }
        catch (Throwable throwable) {
            IOHelper.close(fr);
            throw throwable;
        }
        IOHelper.close(fr);
        return linkedList;
    }

    private DiffRevisionsInfo processMatches(DiffMatcher.Header fromHeader, DiffMatcher.Header toHeader, DiffMatcher.Section section) {
        DiffRevisionsInfo dri = new DiffRevisionsInfo();
        int fromLines = section.getNumberFromLines() == null ? 0 : Integer.parseInt(section.getNumberFromLines());
        dri.setFromLines(fromLines);
        int toLines = section.getNumberToLines() == null ? 0 : Integer.parseInt(section.getNumberToLines());
        dri.setToLines(toLines);
        if (fromHeader.isNullRev()) {
            dri.setPath(new Path(toHeader.getPath()));
            dri.setFromRevisionName(null);
            dri.setToRevisionName(WORKING_COPY);
            return dri;
        }
        if (toHeader.isNullRev()) {
            dri.setPath(new Path(fromHeader.getPath()));
            dri.setFromRevisionName(fromHeader.getRevision());
            dri.setToRevisionName(null);
            return dri;
        }
        dri.setPath(new Path(fromHeader.getPath()));
        dri.setFromRevisionName(fromHeader.getRevision());
        dri.setToRevisionName(WORKING_COPY);
        return dri;
    }
}

