/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.source;

import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.FileRevision;
import com.cenqua.crucible.model.FileRevisionException;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.revision.FileInfo;
import com.cenqua.crucible.revision.RepositoryFileInfo;
import com.cenqua.crucible.revision.source.RepositoryFRXDO;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.util.ReviewCreationHelper;
import com.cenqua.crucible.view.FRXDO;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cache.RevisionContentsUtil;
import com.cenqua.fisheye.diff.LineComparator;
import com.cenqua.fisheye.diff.view.DiffPrinter;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.web.DiffExplorer;
import com.cenqua.fisheye.web.FileDiffExplorer;
import com.cenqua.fisheye.web.ViewFileAction;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class RepositorySource
extends Source {
    private final boolean authorized;
    private final RepositoryHandle rh;
    private final RepositoryEngine engine;

    public RepositorySource(String sourceName, UserLogin user) {
        RepositoryEngine engine = null;
        String reason = "";
        boolean authorized = false;
        this.sourceName = sourceName;
        String repoName = this.getSourceIdentifier();
        this.rh = AppConfig.getsConfig().getRepositoryManager().getRepository(repoName);
        if (this.rh == null) {
            reason = "Repository " + repoName + " does not exist";
        } else {
            UserManager feum = AppConfig.getsConfig().getUserManager();
            authorized = feum.hasPermissionToAccess(user, this.rh);
            if (!authorized) {
                reason = "You are not authorized to access this repository";
            } else {
                try {
                    engine = this.rh.acquireEngine();
                }
                catch (RepositoryHandle.StateException e2) {
                    Logs.APP_LOG.error((Object)e2);
                    reason = e2.getMessage();
                }
            }
        }
        this.engine = engine;
        this.authorized = authorized;
        this.reason = reason;
    }

    public RepositorySource(String sourceName, HttpServletRequest request) {
        this(sourceName, AppConfig.getsConfig().getUserManager().getCurrentUser(request));
    }

    public boolean isAuthorized() {
        return this.authorized;
    }

    public boolean isAvailable() {
        return this.getRepoEngine() != null;
    }

    public RepositoryHandle getRepositoryHandle() {
        return this.rh;
    }

    public RepositoryEngine getRepoEngine() {
        return this.engine;
    }

    public com.cenqua.fisheye.rep.FileRevision getFeFileRevision(FileRevision fileRevision) throws FileRevisionException {
        com.cenqua.fisheye.rep.FileRevision feFileRevision;
        Path path = new Path(fileRevision.getPath());
        RevInfoKey rik = new RevInfoKey(path, fileRevision.getRevIdent());
        if (this.isAvailable()) {
            try {
                feFileRevision = this.getRepoEngine().getRevisionCache().getFileRevision(rik);
            }
            catch (DbException e2) {
                Logs.APP_LOG.error((Object)"Unexpected problem getting fe revision", (Throwable)e2);
                throw new FileRevisionException(e2);
            }
        } else {
            Logs.APP_LOG.warn((Object)("Unexpected problem getting fe revision " + this.getReason()));
            throw new FileRevisionException(this.getReason());
        }
        return feFileRevision;
    }

    public String getChangeSetId(FileRevision fileRevision) {
        try {
            com.cenqua.fisheye.rep.FileRevision fr = this.getFeFileRevision(fileRevision);
            return fr == null ? null : fr.getChangeSetId();
        }
        catch (FileRevisionException e2) {
            Logs.APP_LOG.error((Object)e2);
            return null;
        }
    }

    public FileInfo getFileInfo(FileRevision fileRevision) throws FileRevisionException {
        return new RepositoryFileInfo(this.getFeFileRevision(fileRevision));
    }

    public List getAnnotatedAncestors(FileRevisionExtraInfo frx) throws Exception {
        FileRevision cruToRev = frx.getFileRevision();
        FileRevision cruFromRev = frx.getFromRevision();
        if (!this.isAvailable()) {
            throw this.getException();
        }
        ReviewCreationHelper ch = new ReviewCreationHelper(this.getRepoEngine(), frx.getReview());
        final com.cenqua.fisheye.rep.FileRevision fromRev = cruFromRev == null ? null : this.getFeFileRevision(cruFromRev);
        final LinkedList result = new LinkedList();
        ch.visitAncestors(cruToRev, new ReviewCreationHelper.AncestorVisitor(){

            public boolean visitUnreviewed(com.cenqua.fisheye.rep.FileRevision fr) {
                result.add(new AncestorAnnotationDO(fr, this.currentlySelected(fr)));
                return true;
            }

            public boolean visitReviewed(com.cenqua.fisheye.rep.FileRevision fr, Collection reviews) {
                result.add(new AncestorAnnotationDO(fr, this.currentlySelected(fr), new ArrayList(reviews)));
                return true;
            }

            private boolean currentlySelected(com.cenqua.fisheye.rep.FileRevision fr) {
                return fromRev != null && fromRev.getRevID() == fr.getRevID();
            }
        });
        return result;
    }

    public boolean isAnySuccessorRevisions(FileRevision currentRevision) {
        return !this.getLatestRevIdent(currentRevision).equals(currentRevision.getRevIdent());
    }

    public String getLatestRevIdent(FileRevision currentRevision) {
        RepositoryEngine repEngine = this.getRepoEngine();
        try {
            if (repEngine != null) {
                RevisionCache revCache = repEngine.getRevisionCache();
                com.cenqua.fisheye.rep.FileRevision current = this.getFeFileRevision(currentRevision);
                int last = revCache.findLastSuccessor(current.getRevID());
                Logs.APP_LOG.debug((Object)("last revid:" + last + " currentRevIdent:" + currentRevision.getRevIdent()));
                return revCache.getFileRevision(last).getRevision();
            }
        }
        catch (DbException e2) {
            Logs.APP_LOG.error((Object)"Database error while getting latest revision. ", (Throwable)e2);
        }
        catch (FileRevisionException e3) {
            Logs.APP_LOG.error((Object)"Problem finding own revision.", (Throwable)e3);
        }
        return currentRevision.getRevIdent();
    }

    public DiffPrinter getDiffPrinter(FileRevisionExtraInfo frx, String keywordOpts, String diffOpts, int context, boolean sideBySide, boolean softWrap) throws Exception {
        return this.getDiffExp(frx, keywordOpts, diffOpts, context, sideBySide, softWrap).getPrinter();
    }

    private DiffExplorer getDiffExp(FileRevisionExtraInfo frx, String keywordOpts, String diffOpts, int context, boolean sideBySide, boolean softWrap) throws Exception {
        if (!this.isAvailable()) {
            throw this.getException();
        }
        if (frx.getFromRevision() == null) {
            throw new Exception("Not enough revisions to diff");
        }
        com.cenqua.fisheye.rep.FileRevision fromRev = this.getFeFileRevision(frx.getFromRevision());
        com.cenqua.fisheye.rep.FileRevision toRev = this.getFeFileRevision(frx.getFileRevision());
        if (toRev.isDead()) {
            toRev = null;
        }
        Disposer disposer = Disposer.threadInstance();
        FileDiffExplorer diffExp = ViewFileAction.diffRevisions(disposer, this.getRepoEngine().getRevisionCache(), fromRev, toRev, LineComparator.fromDiffOption(diffOpts), keywordOpts, sideBySide, softWrap);
        diffExp.setContextLines(context);
        return diffExp;
    }

    public FRXDO getFRXDO(FileRevisionExtraInfo frx, CrucibleUser currentUser, String keywordOpts, boolean sideBySide, boolean softWrap) throws Exception {
        return new RepositoryFRXDO(frx, currentUser, keywordOpts, sideBySide, softWrap);
    }

    public Blame getBlame(FileRevision toRevision) throws Exception {
        RevisionCache rc = this.getRepoEngine().getRevisionCache();
        com.cenqua.fisheye.rep.FileRevision toRev = this.getFeFileRevision(toRevision);
        return rc.getBlame(toRev.getRevInfoKey());
    }

    public IndexedLineReader getFileContents(FileRevision toRevision, File tmpFile, String kopts) throws Exception {
        RevisionCache rc = this.getRepoEngine().getRevisionCache();
        com.cenqua.fisheye.rep.FileRevision toRev = this.getFeFileRevision(toRevision);
        return RevisionContentsUtil.getUnicodeTextRevision(rc, toRev, tmpFile, kopts, null);
    }

    public void insertLinks(CharSequence charSequence, RegionList regions) {
        this.getRepositoryHandle().getCfg().getLinker().insertLinks(charSequence, regions);
    }

    public static class AncestorAnnotationDO {
        private final com.cenqua.fisheye.rep.FileRevision feRevision;
        private final List otherReviews;
        private final boolean currentlySelected;

        public AncestorAnnotationDO(com.cenqua.fisheye.rep.FileRevision feRevision, boolean currentlySelected) {
            this(feRevision, currentlySelected, Collections.EMPTY_LIST);
        }

        public AncestorAnnotationDO(com.cenqua.fisheye.rep.FileRevision feRevision, boolean currentlySelected, List otherReviews) {
            this.feRevision = feRevision;
            this.currentlySelected = currentlySelected;
            this.otherReviews = otherReviews;
        }

        public com.cenqua.fisheye.rep.FileRevision getFeRevision() {
            return this.feRevision;
        }

        public boolean isCurrentlySelected() {
            return this.currentlySelected;
        }

        public List getReviews() {
            return this.otherReviews;
        }

        public String getReviewsString() {
            StringBuffer buf = new StringBuffer();
            String sep = "";
            for (Object otherReview : this.otherReviews) {
                Review r = (Review)otherReview;
                buf.append(sep).append(r.getPermaId());
                sep = " ";
            }
            return buf.toString();
        }
    }
}

