/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.tags;

import com.cenqua.crucible.view.FRXDO;
import com.cenqua.crucible.view.LineDO;
import com.cenqua.fisheye.diff.view.LinePair;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.web.tags.AbstractRegionListTag;
import java.io.IOException;
import javax.servlet.jsp.JspException;

public class OutputLineTag
extends AbstractRegionListTag {
    private static RegionList EMPTY_REGIONS = new RegionList();
    private LineDO lineDO;
    private FRXDO frxDO;
    private boolean from;

    public void setLineDO(LineDO lineDO) {
        this.lineDO = lineDO;
    }

    public void setFrxDO(FRXDO frxDO) {
        this.frxDO = frxDO;
    }

    public void doTag() throws JspException {
        try {
            this.setEol("");
            this.output(this.from ? this.lineDO.getLinePair().getFrom() : this.lineDO.getLinePair().getTo());
        }
        catch (Exception e2) {
            Logs.APP_LOG.warn((Object)"Problem rendering diff line", (Throwable)e2);
            throw new JspException((Throwable)e2);
        }
    }

    private void output(LinePair.Line line) throws IOException {
        try {
            CharSequence txt = line.getLine();
            RegionList regions = line.getStyleRegions();
            this.outputRegion(txt, regions, 0, txt.length());
        }
        catch (RuntimeException e2) {
            Logs.APP_LOG.error((Object)("Error displaying line " + line.getLineNumber() + " for file " + this.frxDO.getToRevision().getFileName() + " : " + e2.getMessage()));
            throw e2;
        }
    }

    protected String getSpanClass(Region region) {
        return this.getStandardSpanClass(region, this.from);
    }

    public void setFrom(boolean from) {
        this.from = from;
    }
}

