/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.util;

import com.cenqua.crucible.model.FileRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.revision.diff.DiffRevisionsInfo;
import java.io.IOException;
import java.util.List;

public class PatchReviewCreationHelper {
    private static String getIndexNumber(FileRevision fr) {
        return fr.getRevIdent().split(":")[0];
    }

    public static FileRevisionExtraInfo getFRXForRevFromPatch(int revId, Review review) {
        FileRevision fr = FileRevisionManager.getById(revId);
        if (fr == null) {
            return null;
        }
        return PatchReviewCreationHelper.getFRXForRevFromPatch(fr, review);
    }

    public static FileRevisionExtraInfo getFRXForRevFromPatch(FileRevision fr, Review review) {
        FileRevision fromFr;
        FileRevisionExtraInfo frx = review.addFileRevision(fr);
        if (fr.getRevIdent().endsWith(":T") && (fromFr = FileRevisionManager.findRevision(fr.getSource().getSourceName(), fr.getPath(), PatchReviewCreationHelper.getIndexNumber(fr) + ":F")) != null) {
            frx.setFromRevision(fromFr);
        }
        return frx;
    }

    public static void addAllPatchRevsToReview(Patch patch, Review review) throws IOException {
        List<DiffRevisionsInfo> dris = patch.getDiffRevisions();
        for (DiffRevisionsInfo dri : dris) {
            PatchReviewCreationHelper.getFRXForRevFromPatch(patch.getFileRevisionFromDRI(dri), review);
        }
    }
}

