/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.util;

import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.FileRevision;
import com.cenqua.crucible.model.FileRevisionException;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceException;
import com.cenqua.crucible.util.FileRevisionToReviewMapper;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RevInfoKey;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewCreationHelper {
    private final Review review;
    private final RepositoryEngine rep;
    private final List<FileRevisionExtraInfo> addedItems = new LinkedList<FileRevisionExtraInfo>();
    private final List<FileRevision> removedItems = new LinkedList<FileRevision>();
    private final List<String> messages = new LinkedList<String>();

    public ReviewCreationHelper(RepositorySource source, Review review) throws SourceException {
        this.review = review;
        if (!source.isAvailable()) {
            throw source.getException();
        }
        this.rep = source.getRepoEngine();
    }

    public ReviewCreationHelper(RepositoryEngine rep, Review review) {
        this.review = review;
        this.rep = rep;
    }

    public List<FileRevisionExtraInfo> getAddedItems() {
        return this.addedItems;
    }

    public List<FileRevision> getRemovedItems() {
        return this.removedItems;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public boolean inThisIteration(RevInfoKey rk) {
        FileRevision crev = FileRevisionManager.findRevision(Source.getRepoSourceName(this.rep.getName()), rk);
        if (crev == null) {
            return false;
        }
        FileRevisionExtraInfo frx = FRXManager.getFRExtraInfo(crev, this.review);
        return frx != null;
    }

    public void visitAncestors(FileRevision cfr, AncestorVisitor v) throws DbException, RepositoryHandle.StateException, FileRevisionException {
        Source source = cfr.getSource();
        if (!(source instanceof RepositorySource)) {
            return;
        }
        RepositorySource s = (RepositorySource)source;
        com.cenqua.fisheye.rep.FileRevision fr = s.getFeFileRevision(cfr);
        this.visitAncestors(s, fr, v);
    }

    public void visitAncestors(RepositorySource s, com.cenqua.fisheye.rep.FileRevision fr, AncestorVisitor v) throws DbException, RepositoryHandle.StateException {
        com.cenqua.fisheye.rep.FileRevision current;
        if (!s.isAvailable()) {
            this.messages.add(s.getReason());
            return;
        }
        RevisionCache cache = s.getRepoEngine().getRevisionCache();
        FileRevisionToReviewMapper finder = new FileRevisionToReviewMapper(s.getSourceName());
        RevInfoKey nextKey = fr.getDiffRevision();
        boolean keepGoing = true;
        while (nextKey != null && keepGoing && (current = cache.getFileRevision(nextKey)) != null) {
            nextKey = current.getDiffRevision();
            Collection reviews = finder.findReviewsForRevision(current.getRevInfoKey());
            if (reviews.isEmpty()) {
                keepGoing = v.visitUnreviewed(current);
                continue;
            }
            keepGoing = v.visitReviewed(current, reviews);
        }
    }

    public com.cenqua.fisheye.rep.FileRevision guessBestDiffAncestor(FileRevision cfr) throws DbException, RepositoryHandle.StateException, FileRevisionException {
        class Guesser
        implements AncestorVisitor {
            com.cenqua.fisheye.rep.FileRevision first;
            com.cenqua.fisheye.rep.FileRevision guess;

            Guesser() {
            }

            public boolean visitUnreviewed(com.cenqua.fisheye.rep.FileRevision fr) {
                if (this.first == null) {
                    this.first = fr;
                }
                return true;
            }

            public boolean visitReviewed(com.cenqua.fisheye.rep.FileRevision fr, Collection reviews) {
                if (this.first == null) {
                    this.first = fr;
                }
                this.guess = fr;
                return false;
            }
        }
        Guesser v = new Guesser();
        this.visitAncestors(cfr, v);
        return v.guess != null ? v.guess : v.first;
    }

    public com.cenqua.fisheye.rep.FileRevision firstDiffAncestor(FileRevision cfr) throws DbException, RepositoryHandle.StateException, FileRevisionException {
        class Guesser
        implements AncestorVisitor {
            com.cenqua.fisheye.rep.FileRevision first;

            Guesser() {
            }

            public boolean visitUnreviewed(com.cenqua.fisheye.rep.FileRevision fr) {
                this.first = fr;
                return false;
            }

            public boolean visitReviewed(com.cenqua.fisheye.rep.FileRevision fr, Collection reviews) {
                this.first = fr;
                return false;
            }
        }
        Guesser v = new Guesser();
        this.visitAncestors(cfr, v);
        return v.first;
    }

    public static void addLatestRevisions(Review review, List currentRevisions, boolean changedOnly) throws DbException {
        throw new DbException("NYI");
    }

    public void removeRevisions(CrucibleUser currentUser, int[] revIDs) throws DbException {
        for (int revID : revIDs) {
            com.cenqua.fisheye.rep.FileRevision rev = this.rep.getRevisionCache().getFileRevision(revID);
            if (rev == null) {
                Logs.APP_LOG.warn((Object)("problem getting revision for revid " + revID));
                continue;
            }
            this.removeRevision(currentUser, rev);
        }
    }

    public void removeAllRevisions(CrucibleUser currentUser) {
        List<FileRevision> revisions = this.review.getFileRevisions();
        for (FileRevision fr : revisions) {
            if (this.review.removeFileRevision(fr)) {
                LogManager.log(currentUser.getDisplayName() + " removing revision " + fr.getPath() + " r" + fr.getRevIdent() + " from " + this.review.getPermaId());
                this.removedItems.add(fr);
                continue;
            }
            this.messages.add("Could not remove " + fr.getPath() + " " + fr.getRevIdent() + " it's already been removed or it has comments.");
        }
    }

    private void removeRevision(CrucibleUser currentUser, com.cenqua.fisheye.rep.FileRevision rev) {
        FileRevision fr = FileRevisionManager.createRevision(Source.getRepoSourceName(this.rep.getName()), rev);
        if (this.review.removeFileRevision(fr)) {
            LogManager.log(currentUser.getDisplayName() + " removing revision " + fr.getPath() + " r" + fr.getRevIdent() + " from " + this.review.getPermaId());
            this.removedItems.add(fr);
        } else {
            this.messages.add("Could not remove " + rev.getPath().getName() + " " + rev.getRevision() + " it's already been removed or it has comments.");
        }
    }

    public void addRevisions(CrucibleUser currentUser, int[] revIDs, boolean diffToFirst) throws DbException, RepositoryHandle.StateException, FileRevisionException {
        for (int revID : revIDs) {
            com.cenqua.fisheye.rep.FileRevision fr = this.rep.getRevisionCache().getFileRevision(revID);
            if (fr == null) {
                Logs.APP_LOG.warn((Object)("problem getting revision for revid " + revID));
                continue;
            }
            this.tryToAddRevision(currentUser, fr, diffToFirst);
        }
    }

    public void addRevisions(CrucibleUser currentUser, Collection<com.cenqua.fisheye.rep.FileRevision> revisions, boolean diffToFirst) throws DbException, RepositoryHandle.StateException, FileRevisionException {
        for (com.cenqua.fisheye.rep.FileRevision fr : revisions) {
            this.tryToAddRevision(currentUser, fr, diffToFirst);
        }
    }

    public ChangeSet addChangeSet(CrucibleUser currentUser, String csid, boolean diffToFirst) throws DbException, RepositoryHandle.StateException, FileRevisionException {
        ChangeSet cs = this.rep.getRevisionCache().getChangeSet(csid);
        Iterator<com.cenqua.fisheye.rep.FileRevision> iterator = cs.getRevisionInfos();
        while (iterator.hasNext()) {
            com.cenqua.fisheye.rep.FileRevision fr = iterator.next();
            this.tryToAddRevision(currentUser, fr, diffToFirst);
        }
        return cs;
    }

    private void tryToAddRevision(CrucibleUser currentUser, com.cenqua.fisheye.rep.FileRevision rev, boolean diffToFirst) throws DbException, RepositoryHandle.StateException, FileRevisionException {
        FileRevision fr = FileRevisionManager.createRevision(Source.getRepoSourceName(this.rep.getName()), rev);
        if (FRXManager.getFRExtraInfo(fr, this.review) != null) {
            this.messages.add(rev.getPath().getName() + " " + rev.getRevision() + " already added.");
            return;
        }
        List<FileRevisionExtraInfo> similarFrxs = FRXManager.getFRExtraInfos(fr.getPath(), this.review);
        for (FileRevisionExtraInfo similarFrx : similarFrxs) {
            try {
                com.cenqua.fisheye.rep.FileRevision similarRev = ((RepositorySource)similarFrx.getFileRevision().getSource()).getFeFileRevision(similarFrx.getFileRevision());
                if (!rev.getBranch().equals(similarRev.getBranch())) continue;
                if (this.isBefore(rev, similarFrx)) {
                    similarFrx.setFromRevision(fr);
                    this.logUpdatingFrx(similarFrx, similarFrx.getFromRevision(), currentUser);
                    this.messages.add("Updated " + rev.getPath().getName() + " " + similarFrx.getFileRevision().getRevisionName() + " change diff to " + rev.getRevision());
                    return;
                }
                if (this.isAfter(rev, similarFrx)) {
                    FileRevision fromRev = similarFrx.getFromRevision();
                    if (this.review.removeFRX(similarFrx)) {
                        FileRevisionExtraInfo frx = this.review.addFileRevision(fr);
                        frx.setFromRevision(fromRev);
                        this.logReplacingFrx(similarFrx, frx, currentUser);
                        this.messages.add("Added " + rev.getPath().getName() + " " + rev.getRevision() + ", which replaced " + similarRev.getRevision() + " already in the review");
                        this.addedItems.add(frx);
                        this.removedItems.add(similarFrx.getFileRevision());
                    } else {
                        this.messages.add("Could not replace " + rev.getPath().getName() + " " + rev.getRevision() + " it has comments.");
                    }
                    return;
                }
                this.messages.add(rev.getPath().getName() + " " + rev.getRevision() + " is already included in this review.");
                return;
            }
            catch (FileRevisionException e2) {
                this.messages.add("Couldn't check revision " + similarFrx.getFileRevision().getRevIdent() + ". (" + e2.getMessage() + ")");
            }
        }
        FileRevisionExtraInfo frx = this.makeFrx(fr, diffToFirst);
        this.logAddingFrx(frx, currentUser);
        this.addedItems.add(frx);
    }

    private boolean isAfter(com.cenqua.fisheye.rep.FileRevision revision, FileRevisionExtraInfo similarFrx) throws FileRevisionException, DbException {
        com.cenqua.fisheye.rep.FileRevision similarRev = ((RepositorySource)similarFrx.getFileRevision().getSource()).getFeFileRevision(similarFrx.getFileRevision());
        return this.rep.getRevisionCache().isAfter(revision.getRevID(), similarRev.getRevID());
    }

    private boolean isBefore(com.cenqua.fisheye.rep.FileRevision revision, FileRevisionExtraInfo similarFrx) throws FileRevisionException, DbException {
        if (similarFrx.getFromRevision() == null) {
            return false;
        }
        com.cenqua.fisheye.rep.FileRevision similarFromRev = ((RepositorySource)similarFrx.getFileRevision().getSource()).getFeFileRevision(similarFrx.getFromRevision());
        return this.rep.getRevisionCache().isBefore(revision.getRevID(), similarFromRev.getRevID());
    }

    private FileRevisionExtraInfo makeFrx(FileRevision fr, boolean diffToFirst) throws DbException, RepositoryHandle.StateException, FileRevisionException {
        com.cenqua.fisheye.rep.FileRevision bestDiffAncestor;
        FileRevisionExtraInfo frx = this.review.addFileRevision(fr);
        com.cenqua.fisheye.rep.FileRevision fileRevision = bestDiffAncestor = diffToFirst ? this.firstDiffAncestor(fr) : this.guessBestDiffAncestor(fr);
        if (bestDiffAncestor != null) {
            frx.setFromRevision(FileRevisionManager.createRevision(Source.getRepoSourceName(this.rep.getName()), bestDiffAncestor));
        }
        return frx;
    }

    private void logAddingFrx(FileRevisionExtraInfo frx, CrucibleUser currentUser) {
        LogManager.log(currentUser.getDisplayName() + " adding revision " + frx.getFileRevision().getPath() + " r" + (frx.getFromRevision() != null ? frx.getFromRevision().getRevIdent() + "-" : "") + frx.getFileRevision().getRevIdent() + " to " + this.review.getPermaId());
    }

    private void logReplacingFrx(FileRevisionExtraInfo removedFrx, FileRevisionExtraInfo addedFrx, CrucibleUser currentUser) {
        LogManager.log(currentUser.getDisplayName() + " adding revision " + addedFrx.getFileRevision().getPath() + " r" + (addedFrx.getFromRevision() != null ? addedFrx.getFromRevision().getRevIdent() + "-" : "") + addedFrx.getFileRevision().getRevIdent() + " to " + this.review.getPermaId() + " replacing " + removedFrx.getFileRevision().getPath() + " r" + (removedFrx.getFromRevision() != null ? removedFrx.getFromRevision().getRevIdent() + "-" : "") + removedFrx.getFileRevision().getRevIdent());
    }

    private void logUpdatingFrx(FileRevisionExtraInfo updatedFrx, FileRevision oldFromRevision, CrucibleUser currentUser) {
        LogManager.log(currentUser.getDisplayName() + " updated revision " + updatedFrx.getFileRevision().getPath() + " r" + (updatedFrx.getFromRevision() != null ? updatedFrx.getFromRevision().getRevIdent() + "-" : "") + updatedFrx.getFileRevision().getRevIdent() + " (fromRevision was '" + (oldFromRevision != null ? oldFromRevision.getRevIdent() : "") + "')");
    }

    public static interface AncestorVisitor {
        public boolean visitUnreviewed(com.cenqua.fisheye.rep.FileRevision var1);

        public boolean visitReviewed(com.cenqua.fisheye.rep.FileRevision var1, Collection var2);
    }
}

