/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.cenqua.crucible.view.FRXDO;
import com.cenqua.crucible.view.RevisionCommentDO;
import com.cenqua.fisheye.diff.Section;
import com.cenqua.fisheye.diff.view.LinePair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class LineDO {
    private LinePair linepair;
    private LinkedHashMap commentsMap = new LinkedHashMap();
    private List invisibleComments;
    private FRXDO frxDO;

    public LineDO(LinePair linepair, FRXDO frxDO) {
        this.linepair = linepair;
        this.frxDO = frxDO;
        if (linepair.getTo() != null) {
            this.addComments(frxDO.getToCommentsOnLine(linepair.getTo().getLineNumber() + 1));
        }
        if (linepair.getFrom() != null) {
            this.addComments(frxDO.getFromCommentsOnLine(linepair.getFrom().getLineNumber() + 1));
        }
    }

    public String getLineId() throws Exception {
        if (this.linepair.getSection().isCommonSubsequence() || this.isSideBySide() && this.linepair.getShowFrom() && this.linepair.getShowTo()) {
            return this.makeLineId("Both", this.linepair.getFrom().getLineNumber() + 1, this.linepair.getTo().getLineNumber() + 1);
        }
        if (this.linepair.getShowFrom()) {
            return this.makeLineId("From", this.linepair.getFrom().getLineNumber() + 1);
        }
        return this.makeLineId("", this.linepair.getTo().getLineNumber() + 1);
    }

    private boolean isSideBySide() throws Exception {
        return this.frxDO.getDiffDO().getDiffPrinter().isSideBySide();
    }

    private String makeLineId(String type, int line) {
        return this.makeLineId(type, Integer.toString(line), null);
    }

    private String makeLineId(String type, int start, int end) {
        return this.makeLineId(type, Integer.toString(start), Integer.toString(end));
    }

    private String makeLineId(String type, String start, String end) {
        StringBuilder sb = new StringBuilder(this.frxDO.getId().toString());
        sb.append("_line").append(type).append(start);
        if (end != null) {
            sb.append(",").append(end);
        }
        return sb.toString();
    }

    public LinePair getLinePair() {
        return this.linepair;
    }

    public Section getSection() {
        return this.linepair.getSection();
    }

    public List getComments() {
        return new ArrayList(this.commentsMap.values());
    }

    private void addComments(List comments) {
        for (RevisionCommentDO c2 : comments) {
            this.commentsMap.put(c2.getId(), c2);
        }
    }

    public List getInvisibleComments() {
        return this.invisibleComments;
    }

    public void setInvisibleComments(List invisibleComments) {
        this.invisibleComments = invisibleComments;
    }

    public boolean isSkippedPrevious() {
        return this.linepair.isStartOfSection() && this.getSection().isSkippedPrevious();
    }
}

