/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.managers.CommentManager;
import java.util.HashMap;
import java.util.Set;

public class ParticipantStats {
    private Review review;
    private HashMap participants = new HashMap();

    public ParticipantStats(Review review) {
        this.review = review;
        this.mapParticipantStats();
    }

    private void mapParticipantStats() {
        Set<ReviewParticipant> team = this.review.getTeam();
        for (ReviewParticipant p : team) {
            CrucibleUser user = p.getUser();
            HashMap<String, Integer> stats = new HashMap<String, Integer>();
            int totalDraftComments = CommentManager.countReviewGeneralComment(this.review, user, Boolean.TRUE, Boolean.FALSE, null) + CommentManager.getReviewFrxsCommentCount(this.review, user, Boolean.TRUE, Boolean.FALSE, null);
            stats.put("totalDraftComments", new Integer(totalDraftComments));
            int totalPostedComments = CommentManager.countReviewGeneralComment(this.review, user, Boolean.FALSE, Boolean.FALSE, null) + CommentManager.getReviewFrxsCommentCount(this.review, user, Boolean.FALSE, Boolean.FALSE, null);
            stats.put("totalPostedComments", new Integer(totalPostedComments));
            int totalPostedDefectComments = CommentManager.countReviewGeneralComment(this.review, user, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE) + CommentManager.getReviewFrxsCommentCount(this.review, user, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE);
            stats.put("totalPostedDefectComments", new Integer(totalPostedDefectComments));
            this.participants.put(user, stats);
        }
    }

    public HashMap getParticipantStats() {
        return this.participants;
    }
}

