/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.cenqua.crucible.actions.PagedSearch;
import com.cenqua.crucible.filters.CrucibleFilter;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.crucible.util.HqlUtil;
import com.cenqua.crucible.view.ReviewFilters;
import com.cenqua.crucible.view.RowDetail;
import com.cenqua.crucible.view.StateDO;
import com.cenqua.fisheye.util.NaturalComparator;
import com.cenqua.fisheye.web.UrlHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewFilterState {
    private ReviewFilters reviewFilters;
    private List<Integer> filteredReviewIds;
    private String title;
    private String filter;
    private HttpSession httpSes;
    private String[] state;
    private String author;
    private String moderator;
    private String creator;
    private String reviewer;
    private String filterName;
    private String filterDescription;
    private String FILTER = "com.cenqua.crucible.actions.ReviewQueryAction.filter";
    private String FILTER_DEF = "com.cenqua.crucible.actions.ReviewQueryAction.filterDef";
    private String FILTER_TITLE = "com.cenqua.crucible.actions.ReviewQueryAction.filterTitle";
    public static String COMPLETE_ANY = "any";
    public static String COMPLETE = "complete";
    public static String COMPLETE_NOT = "incomplete";
    private LinkedHashMap<Integer, RowDetail> reviewDetails;
    private Project project;
    private boolean orRoles;
    private Boolean complete;
    private final String defaultFilter;

    public ReviewFilterState(CrucibleUser user, String defaultFilter, String actionName) {
        this.defaultFilter = defaultFilter;
        this.reviewFilters = new ReviewFilters(user);
        this.httpSes = CrucibleFilter.getRequest().getSession();
        if (this.httpSes.getAttribute(this.FILTER) == null) {
            this.setFilter(defaultFilter);
        }
        this.FILTER = "com.cenqua.crucible.actions." + actionName + ".filter";
        this.FILTER_DEF = "com.cenqua.crucible.actions." + actionName + ".filterDef";
        this.FILTER_TITLE = "com.cenqua.crucible.actions." + actionName + ".filterTitle";
    }

    public String[] getState() {
        return this.state;
    }

    public Collection getStates() {
        List<State> states = StateManager.INSTANCE.getStates();
        LinkedList<StateDO> wrappedStates = new LinkedList<StateDO>();
        for (State state1 : states) {
            wrappedStates.add(new StateDO(state1, this.state));
        }
        return wrappedStates;
    }

    public void setState(String[] state) {
        this.state = state;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public String getFilterDescription() {
        return this.filterDescription;
    }

    public boolean getOrRoles() {
        return this.orRoles;
    }

    public void setOrRoles(boolean orRoles) {
        this.orRoles = orRoles;
    }

    public String getComplete() {
        if (this.complete == null) {
            return COMPLETE_ANY;
        }
        if (this.complete.booleanValue()) {
            return COMPLETE;
        }
        return COMPLETE_NOT;
    }

    public void setComplete(String complete) {
        if (COMPLETE.equals(complete)) {
            this.complete = Boolean.TRUE;
            return;
        }
        if (COMPLETE_NOT.equals(complete)) {
            this.complete = Boolean.FALSE;
            return;
        }
        this.complete = null;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getModerator() {
        return this.moderator;
    }

    public void setModerator(String moderator) {
        this.moderator = moderator;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getReviewer() {
        return this.reviewer;
    }

    public void setReviewer(String reviewer) {
        this.reviewer = reviewer;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public List<RowDetail> getFilteredReviewDetails(PagedSearch pagedSearch) {
        List reviewIds = this.getFilteredReviewIds();
        LinkedHashMap<Integer, RowDetail> reviewDetails = this.getReviewDetailsMap();
        ArrayList<RowDetail> details = new ArrayList<RowDetail>();
        int end = pagedSearch.getEnd();
        for (int i2 = pagedSearch.getStart(); i2 < end; ++i2) {
            Integer id = (Integer)reviewIds.get(i2);
            details.add(reviewDetails.get(id));
        }
        return details;
    }

    public List getFilteredReviewIds() {
        List<ReviewFilters.FilterDef> filters = this.getFilterDefByName(this.getFilter());
        this.applyProjectToFilters(filters);
        if (this.filteredReviewIds == null) {
            HashSet<Integer> results = new HashSet<Integer>();
            for (ReviewFilters.FilterDef fd : filters) {
                List ids = ReviewManager.getReviewsAsRolesInStates(fd, this.title, "review.id", "review.id");
                for (Integer id : ids) {
                    Review r = ReviewManager.getById(id);
                    if (!ReviewUtil.principalCanDoReviewAction(CrucibleFilter.getCurrentPrincipal(), "action:viewReview", r)) continue;
                    results.add(id);
                }
            }
            this.filteredReviewIds = new LinkedList<Integer>(results);
            Collections.sort(this.filteredReviewIds, NaturalComparator.REVERSE_INSTANCE);
        }
        return this.filteredReviewIds;
    }

    public long countFilteredReviews(String filter) {
        long count = 0L;
        List<ReviewFilters.FilterDef> filters = this.reviewFilters.getFilterDefsByKey(filter);
        this.applyProjectToFilters(filters);
        for (ReviewFilters.FilterDef fd : filters) {
            count += HqlUtil.getCountFromSet(ReviewManager.getReviewsAsRolesInStates(fd, null, "count(distinct review.id)", null)).longValue();
        }
        return count;
    }

    public int countFilteredReviewResults(String filter) {
        HashSet results = new HashSet();
        List<ReviewFilters.FilterDef> filters = this.reviewFilters.getFilterDefsByKey(filter);
        this.applyProjectToFilters(filters);
        for (ReviewFilters.FilterDef fd : filters) {
            results.addAll(ReviewManager.getReviewsAsRolesInStates(fd, null, "review.id", "review.id"));
        }
        return results.size();
    }

    public List<ReviewFilters.FilterDef> getFilterDefByName(String name) {
        List<ReviewFilters.FilterDef> filters = this.reviewFilters.getFilterDefsByKey(name);
        if (!filters.isEmpty()) {
            ReviewFilters.FilterDef fd = filters.get(0);
            this.filterName = fd.filterName;
            if ("custom".equals(name)) {
                fd.author = CrucibleUserManager.getUserByName(this.author);
                fd.moderator = CrucibleUserManager.getUserByName(this.moderator);
                fd.creator = CrucibleUserManager.getUserByName(this.creator);
                fd.reviewer = CrucibleUserManager.getUserByName(this.reviewer);
                fd.state = this.state;
                fd.project = this.project;
                fd.orRoles = this.orRoles;
                if (fd.reviewer == null && this.complete != null) {
                    fd.allReviewersComplete = this.complete;
                } else {
                    fd.complete = this.complete;
                }
                this.httpSes.setAttribute(this.FILTER_DEF, (Object)fd);
                this.httpSes.setAttribute(this.FILTER_TITLE, (Object)this.getTitle());
            } else {
                this.applyProjectToFilters(filters);
                if (filters.size() == 1) {
                    this.author = fd.author != null ? fd.author.getUserName() : null;
                    this.moderator = fd.moderator != null ? fd.moderator.getUserName() : null;
                    this.creator = fd.creator != null ? fd.creator.getUserName() : null;
                    this.reviewer = fd.reviewer != null ? fd.reviewer.getUserName() : null;
                    this.state = fd.state;
                    this.orRoles = fd.orRoles;
                    this.complete = fd.complete;
                    this.project = fd.project;
                }
            }
        }
        return filters;
    }

    public void setFilter(String filter) {
        this.httpSes.setAttribute(this.FILTER, (Object)filter);
        this.filter = filter;
        List<ReviewFilters.FilterDef> filters = this.reviewFilters.getFilterDefsByKey(filter);
        this.applyProjectToFilters(filters);
        if (!filters.isEmpty()) {
            ReviewFilters.FilterDef fd = filters.get(0);
            this.filterName = fd.filterName;
            this.filterDescription = fd.filterDescription;
        }
    }

    private void applyProjectToFilters(List<ReviewFilters.FilterDef> filters) {
        for (ReviewFilters.FilterDef fdef : filters) {
            fdef.project = this.getProject();
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilterFromSession() {
        if (this.getFilter() == null) {
            String filter = (String)this.httpSes.getAttribute(this.FILTER);
            if (filter == null) {
                filter = this.defaultFilter;
            }
            this.setFilter(filter);
            if (filter != null && filter.equals("custom")) {
                ReviewFilters.FilterDef fd = (ReviewFilters.FilterDef)this.httpSes.getAttribute(this.FILTER_DEF);
                this.author = fd.author != null ? fd.author.getUserName() : null;
                this.moderator = fd.moderator != null ? fd.moderator.getUserName() : null;
                this.creator = fd.creator != null ? fd.creator.getUserName() : null;
                this.reviewer = fd.reviewer != null ? fd.reviewer.getUserName() : null;
                this.state = fd.state;
                this.orRoles = fd.orRoles;
                this.complete = fd.complete;
                this.project = fd.project;
                this.setTitle((String)this.httpSes.getAttribute(this.FILTER_TITLE));
            }
        }
    }

    public String getFilterParams() {
        UrlHelper url = new UrlHelper();
        if (this.getFilter().equals("custom")) {
            url.putParam("title", this.getTitle());
            url.putParam("author", this.author);
            url.putParam("moderator", this.moderator);
            url.putParam("creator", this.creator);
            url.putParam("reviewer", this.reviewer);
            url.putParam("state", this.state);
            url.putParam("orRoles", Boolean.toString(this.orRoles));
            url.putParam("complete", this.complete);
            url.putParam("project", this.project);
        }
        url.putParam("filter", this.getFilter());
        return url.toString();
    }

    public LinkedHashMap<Integer, RowDetail> getReviewDetailsMap() {
        if (this.reviewDetails == null) {
            this.reviewDetails = ReviewManager.getReviewDetailsMap();
        }
        return this.reviewDetails;
    }

    public int getNumberOfResults() {
        return this.getFilteredReviewIds() == null ? 0 : this.getFilteredReviewIds().size();
    }
}

