/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.RevisionComment;
import com.cenqua.crucible.util.LineRangeUtil;
import com.cenqua.crucible.view.CommentDO;
import com.cenqua.fisheye.util.StringUtil;

public class RevisionCommentDO {
    private RevisionComment toRC;
    private RevisionComment fromRC;
    private int lastTo;
    private int lastFrom;
    private boolean matched = false;
    private Comment comment;
    private CrucibleUser currentUser;

    public RevisionCommentDO() {
    }

    public RevisionCommentDO(RevisionComment toRC, RevisionComment fromRC) {
        this.setToRC(toRC);
        this.setFromRC(fromRC);
    }

    public void setToRC(RevisionComment toRC) {
        this.toRC = toRC;
        if (toRC != null) {
            this.comment = toRC.getComment();
            this.lastTo = LineRangeUtil.getLastLineNo(toRC.getLineRange());
        }
    }

    public void setFromRC(RevisionComment fromRC) {
        this.fromRC = fromRC;
        if (fromRC != null) {
            this.comment = fromRC.getComment();
            this.lastFrom = LineRangeUtil.getLastLineNo(fromRC.getLineRange());
        }
    }

    public Integer getId() {
        return this.comment == null ? null : this.comment.getId();
    }

    public boolean isDraft() {
        return this.comment != null && this.comment.isDraft();
    }

    public CommentDO getCommentDO() {
        return this.comment != null ? new CommentDO(this.comment, this.currentUser) : null;
    }

    public String getToLineRange() {
        return this.toRC != null ? this.toRC.getLineRange() : "";
    }

    public String getFromLineRange() {
        return this.fromRC != null ? this.fromRC.getLineRange() : "";
    }

    public String getToRevisionStr() {
        return this.toRC != null ? this.toRC.getRevision().getRevisionName() : "";
    }

    public String getFromRevisionStr() {
        return this.fromRC != null ? this.fromRC.getRevision().getRevisionName() : "";
    }

    public CrucibleUser getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(CrucibleUser currentUser) {
        this.currentUser = currentUser;
    }

    public String getLinesPerRevisionString() {
        String str = "";
        if (this.fromRC != null) {
            str = str + " Revision " + this.getFromRevisionStr();
            if (!StringUtil.nullOrEmpty(this.getFromLineRange())) {
                str = str + " lines " + this.getFromLineRange();
            }
        }
        if (this.toRC != null) {
            str = str + " Revision " + this.getToRevisionStr();
            if (!StringUtil.nullOrEmpty(this.getToLineRange())) {
                str = str + " lines " + this.getToLineRange();
            }
        }
        return str;
    }

    public String getPath() {
        if (this.toRC != null) {
            return this.toRC.getRevision().getPath();
        }
        if (this.fromRC != null) {
            return this.fromRC.getRevision().getPath();
        }
        return null;
    }

    public RevisionComment getToRC() {
        return this.toRC;
    }

    public RevisionComment getFromRC() {
        return this.fromRC;
    }

    public int getLastTo() {
        return this.lastTo;
    }

    public int getLastFrom() {
        return this.lastFrom;
    }

    public boolean isFromOnly() {
        return this.toRC == null && this.fromRC != null;
    }

    public boolean isToOnly() {
        return this.toRC != null && this.fromRC == null;
    }

    public boolean isLastFromLine(int line) {
        if (this.fromRC == null || this.lastFrom != line) {
            return false;
        }
        if (this.matched || this.toRC == null) {
            return true;
        }
        this.matched = true;
        return false;
    }

    public boolean isLastToLine(int line) {
        if (this.toRC == null || this.lastTo != line) {
            return false;
        }
        if (this.matched || this.fromRC == null) {
            return true;
        }
        this.matched = true;
        return false;
    }
}

