/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye;

import com.cenqua.fisheye.config.ConfigProperty;
import com.cenqua.fisheye.config.PropertiesContainer;
import com.cenqua.fisheye.config1.PropertiesType;
import com.cenqua.fisheye.config1.RepositoryDefaultsType;
import com.cenqua.fisheye.config1.RepositoryType;

public class RepositoryProperties {
    private final PropertiesContainer propContainer;
    private final ConfigProperty showChangelogCalendar;
    private final ConfigProperty lineHistoryEnabled;

    public RepositoryProperties(RepositoryDefaultsType defaults) {
        this(new PropertiesContainer[]{RepositoryProperties.asPropertyContainer(defaults)});
    }

    public RepositoryProperties(RepositoryType config, RepositoryDefaultsType defaults) {
        this(new PropertiesContainer[]{RepositoryProperties.asPropertyContainer(config), RepositoryProperties.asPropertyContainer(defaults)});
    }

    private RepositoryProperties(PropertiesContainer[] props) {
        this.propContainer = props[0];
        this.showChangelogCalendar = new ConfigProperty(props, "show-changelog-calendar", "false");
        this.lineHistoryEnabled = new ConfigProperty(props, "enable-line-history", "true");
    }

    public boolean isShowChangelogCalendar() {
        return this.showChangelogCalendar.getBooleanValue();
    }

    public boolean isLineHistoryEnabled() {
        return this.lineHistoryEnabled.getBooleanValue();
    }

    public ConfigProperty getShowChangelogCalendarProp() {
        return this.showChangelogCalendar;
    }

    public ConfigProperty getLineHistoryEnabledProp() {
        return this.lineHistoryEnabled;
    }

    public void cleanup() {
        ConfigProperty.cleanup(this.propContainer);
    }

    private static PropertiesContainer asPropertyContainer(final RepositoryType delegate) {
        return new PropertiesContainer(){

            public boolean isSetProperties() {
                return delegate.isSetProperties();
            }

            public PropertiesType getProperties() {
                return delegate.getProperties();
            }

            public void unsetProperties() {
                delegate.unsetProperties();
            }

            public PropertiesType addNewProperties() {
                return delegate.addNewProperties();
            }
        };
    }

    private static PropertiesContainer asPropertyContainer(final RepositoryDefaultsType delegate) {
        return new PropertiesContainer(){

            public boolean isSetProperties() {
                return delegate.isSetProperties();
            }

            public PropertiesType getProperties() {
                return delegate.getProperties();
            }

            public void unsetProperties() {
                delegate.unsetProperties();
            }

            public PropertiesType addNewProperties() {
                return delegate.addNewProperties();
            }
        };
    }
}

