/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.bucket;

import com.cenqua.fisheye.bucket.BucketDataCollection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class BucketCache {
    private final int MAX_CACHE_SIZE = 10;
    Map<String, BucketDataCollection> data = new HashMap<String, BucketDataCollection>();
    LinkedList<String> order = new LinkedList();

    public void clear() {
        this.data = new HashMap<String, BucketDataCollection>();
        this.order = new LinkedList();
    }

    public BucketDataCollection getData(String key) {
        return this.data.get(key);
    }

    public void addData(BucketDataCollection newData, String newKey) {
        if (this.order.contains(newKey)) {
            this.order.remove(newKey);
        }
        this.order.addFirst(newKey);
        if (this.order.size() > 10) {
            String oldKey = this.order.getLast();
            this.data.remove(oldKey);
            this.order.remove(oldKey);
        }
        this.data.put(newKey, newData);
    }
}

