/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.bucket;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.bucket.BucketCache;
import com.cenqua.fisheye.bucket.BucketData;
import com.cenqua.fisheye.bucket.BucketDataCollection;
import com.cenqua.fisheye.bucket.CalculatedBucketGraphPie;
import com.cenqua.fisheye.bucket.CalculatedBucketGraphXY;
import com.cenqua.fisheye.bucket.Dir;
import com.cenqua.fisheye.bucket.ExtnCollector;
import com.cenqua.fisheye.bucket.InfinityDBConnector;
import com.cenqua.fisheye.bucket.InsertIterator;
import com.cenqua.fisheye.bucket.ParameterSet;
import com.cenqua.fisheye.bucket.ParameterSetInsert;
import com.cenqua.fisheye.bucket.ParameterSetRetrieve;
import com.cenqua.fisheye.bucket.Period;
import com.cenqua.fisheye.bucket.PeriodUnit;
import com.cenqua.fisheye.bucket.RenamingRules;
import com.cenqua.fisheye.bucket.RevCacheReader;
import com.cenqua.fisheye.bucket.SumCollector;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BucketGraph {
    private Dir root;
    private final PeriodUnit periodSlurp = PeriodUnit.DAY;
    private final Object drawGraphAddDataLock = new Object();
    private String repname;
    private final boolean caseSensitive;
    private static BucketCache bucketCache = new BucketCache();

    private TimeZone getTimeZone() throws DbException {
        return TimeZone.getTimeZone(this.root.loadTimeZone());
    }

    public BucketGraph(InfinityDbHandle dbh, String repname, boolean caseSensitive) throws DbException {
        this.root = new Dir(0, new InfinityDBConnector(dbh, repname));
        this.repname = repname;
        this.caseSensitive = caseSensitive;
    }

    Dir getRoot() {
        return this.root;
    }

    public void commit() throws DbException {
        this.root.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRevision(Path path, String branch, Date date, int linecountChange, int numRevisions, String commitAuthor, boolean isTrunklike) throws DbException {
        int bucket = new Period(this.periodSlurp, date, this.getTimeZone()).getBucket();
        Object object = this.drawGraphAddDataLock;
        synchronized (object) {
            bucketCache.clear();
            new InsertIterator().insert(this.root, new ParameterSetInsert(path, branch, bucket, linecountChange, numRevisions, commitAuthor, isTrunklike, this.caseSensitive), -1);
        }
    }

    public void updateRevision(Path path, String branch, Date date, int linecountChange, String commitAuthor, boolean isTrunklike) throws DbException {
        this.addRevision(path, branch, date, linecountChange, 0, commitAuthor, isTrunklike);
    }

    public void addRevision(Path path, String branch, Date date, int linecountChange, String commitAuthor, boolean isTrunklike) throws DbException {
        this.addRevision(path, branch, date, linecountChange, 1, commitAuthor, isTrunklike);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRevision(Path path, String branch, int bucket, int linecountChange, String commitAuthor, boolean isTrunklike) throws DbException {
        Object object = this.drawGraphAddDataLock;
        synchronized (object) {
            bucketCache.clear();
            new InsertIterator().insert(this.root, new ParameterSetInsert(path, branch, bucket, linecountChange, 1, commitAuthor, isTrunklike, this.caseSensitive), -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAuthorBlame(Path path, String branch, Date date, Map<String, Integer> linecountByAuthor, boolean isTrunklike) throws DbException {
        int bucket = new Period(this.periodSlurp, date, this.getTimeZone()).getBucket();
        Object object = this.drawGraphAddDataLock;
        synchronized (object) {
            bucketCache.clear();
            new InsertIterator().insert(this.root, new ParameterSetInsert(path, branch, bucket, linecountByAuthor, 0, isTrunklike, this.caseSensitive), -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateAuthorBlame(Path path, String branch, int bucket, Map<String, Integer> linecountByAuthor, boolean isTrunklike) throws DbException {
        Object object = this.drawGraphAddDataLock;
        synchronized (object) {
            bucketCache.clear();
            new InsertIterator().insert(this.root, new ParameterSetInsert(path, branch, bucket, linecountByAuthor, 0, isTrunklike, this.caseSensitive), -1);
        }
    }

    public CalculatedBucketGraphPie getPieData(ParameterSetRetrieve params, Date date2, RenamingRules renameRules) throws DbException {
        BucketDataCollection bucketsAll = this.getBuckets(params);
        return new CalculatedBucketGraphPie(date2, bucketsAll, this.periodSlurp, this.getTimeZone(), renameRules);
    }

    public CalculatedBucketGraphPie getPieData(ParameterSetRetrieve params, Date date2, RenamingRules renameRules, Integer maxItems) throws DbException {
        if (maxItems == null) {
            return this.getPieData(params, date2, renameRules);
        }
        BucketDataCollection bucketsAll = this.getBuckets(params);
        return new CalculatedBucketGraphPie(date2, bucketsAll, this.periodSlurp, this.getTimeZone(), renameRules, maxItems);
    }

    public CalculatedBucketGraphXY getXYSeries(ParameterSetRetrieve params, int width) throws DbException {
        return this.getXYSeries(params, width, null, null, true, null, null);
    }

    public CalculatedBucketGraphXY getXYSeries(ParameterSetRetrieve params, PeriodUnit periodGraph) throws DbException {
        BucketDataCollection bucketsAll = this.getBuckets(params);
        BucketData buckets = bucketsAll.getFirst();
        if (buckets.size() == 0) {
            return new CalculatedBucketGraphXY();
        }
        return new CalculatedBucketGraphXY(this.getTimeZone(), bucketsAll, params.isTrunkLike(), this.periodSlurp, periodGraph, this.repname, null, null);
    }

    public CalculatedBucketGraphXY getXYSeries(ParameterSetRetrieve params, int width, Date date1, Date date2, boolean isMiniChart, RenamingRules renameRules, Integer maxItems) throws DbException {
        BucketDataCollection bucketsAll = this.getBuckets(params);
        if (bucketsAll.collectionCount() <= 0) {
            return new CalculatedBucketGraphXY();
        }
        return new CalculatedBucketGraphXY(this.getTimeZone(), bucketsAll, params.isTrunkLike(), this.periodSlurp, width, date1, date2, this.repname, isMiniChart, params.isNoBreakdown(), maxItems, renameRules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketDataCollection getBuckets(ParameterSetRetrieve params) throws DbException {
        Object object = this.drawGraphAddDataLock;
        synchronized (object) {
            String key = this.repname + ": " + params.toString();
            BucketDataCollection result = bucketCache.getData(key);
            if (result == null) {
                result = new SumCollector().getBuckets(this.root, params);
                if (params.isNoBreakdown()) {
                    result.renameKey(params.getFormattedLabel());
                }
                bucketCache.addData(result, key);
                return result;
            }
            return result.copy();
        }
    }

    public List<String> getAvailableExtensions(Path path) throws DbException {
        List<String> extns = new ExtnCollector().getAvailableExtensions(this.root, new ParameterSet(path));
        while (extns.contains("__ALL_EXTENSIONS__")) {
            extns.remove("__ALL_EXTENSIONS__");
        }
        while (extns.contains("__NO_EXTENSION__")) {
            extns.remove("__NO_EXTENSION__");
        }
        return extns;
    }

    public String toString() {
        return this.root.toString();
    }

    public String toStringFull() throws DbException {
        return this.root.toStringFull();
    }

    public void reloadFromRevisionCache(RevisionCache cache, RepositoryStatus status) throws DbException {
        RevCacheReader reader = new RevCacheReader(this, cache, status);
        reader.loadFromRevCache();
    }

    InfinityDBConnector getConnector() {
        return this.root.getConnector();
    }

    public boolean isAtCurrentVersion() throws DbException {
        return this.root.getConnector().isAtCurrentVersion();
    }

    public String loadTimeZone() throws DbException {
        return this.root.getConnector().loadTimeZone();
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isAuthorBlameDone(int revid) throws DbException {
        return this.root.getConnector().isAuthorBlameDone(revid);
    }

    public void setAuthorBlameDone(int revid) throws DbException {
        this.root.getConnector().setAuthorBlameDone(revid);
    }

    public void setAuthorBlameDoneMinimum(int revid) throws DbException {
        this.root.getConnector().saveMinAuthorBlameDone(revid);
    }

    public int getAuthorBlameDoneMinimum() throws DbException {
        return this.root.getConnector().loadMinAuthorBlameDone();
    }
}

