/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.bucket;

import com.cenqua.fisheye.bucket.TimeZoneVariables;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PeriodUnit {
    YEAR{

        int dateToBucket(long date, TimeZone timeZone) {
            TimeZoneVariables vars = PeriodUnit.getTimeZoneVariables(timeZone);
            return (int)Math.floor(PeriodUnit.dateToMonthBucket(date, vars.months) / 12);
        }

        long bucketToStartDate(int bucket, TimeZone timeZone) {
            TimeZoneVariables vars = PeriodUnit.getTimeZoneVariables(timeZone);
            return vars.months[bucket * 12];
        }

        long bucketToEndDate(int bucket, TimeZone timeZone) {
            TimeZoneVariables vars = PeriodUnit.getTimeZoneVariables(timeZone);
            return vars.months[(bucket + 1) * 12] - 1L;
        }
    }
    ,
    QUARTER{

        int dateToBucket(long date, TimeZone timeZone) {
            TimeZoneVariables vars = PeriodUnit.getTimeZoneVariables(timeZone);
            return (int)Math.floor(PeriodUnit.dateToMonthBucket(date, vars.months) / 3);
        }

        long bucketToStartDate(int bucket, TimeZone timeZone) {
            TimeZoneVariables vars = PeriodUnit.getTimeZoneVariables(timeZone);
            return vars.months[bucket * 3];
        }

        long bucketToEndDate(int bucket, TimeZone timeZone) {
            TimeZoneVariables vars = PeriodUnit.getTimeZoneVariables(timeZone);
            return vars.months[(bucket + 1) * 3] - 1L;
        }
    }
    ,
    MONTH{

        int dateToBucket(long date, TimeZone timeZone) {
            TimeZoneVariables vars = PeriodUnit.getTimeZoneVariables(timeZone);
            return PeriodUnit.dateToMonthBucket(date, vars.months);
        }

        long bucketToStartDate(int bucket, TimeZone timeZone) {
            TimeZoneVariables vars = PeriodUnit.getTimeZoneVariables(timeZone);
            return vars.months[bucket];
        }

        long bucketToEndDate(int bucket, TimeZone timeZone) {
            TimeZoneVariables vars = PeriodUnit.getTimeZoneVariables(timeZone);
            return vars.months[bucket + 1] - 1L;
        }
    }
    ,
    WEEK{

        int dateToBucket(long date, TimeZone timeZone) {
            TimeZoneVariables vars = PeriodUnit.getTimeZoneVariables(timeZone);
            return (int)Math.floor(PeriodUnit.dateToDayBucket(date, vars) / 7);
        }

        long bucketToStartDate(int bucket, TimeZone timeZone) {
            TimeZoneVariables vars = PeriodUnit.getTimeZoneVariables(timeZone);
            return PeriodUnit.dayBucketToDate(bucket * 7, vars);
        }

        long bucketToEndDate(int bucket, TimeZone timeZone) {
            TimeZoneVariables vars = PeriodUnit.getTimeZoneVariables(timeZone);
            return PeriodUnit.dayBucketToDate((bucket + 1) * 7, vars) - 1L;
        }
    }
    ,
    DAY{

        int dateToBucket(long date, TimeZone timeZone) {
            TimeZoneVariables vars = PeriodUnit.getTimeZoneVariables(timeZone);
            return PeriodUnit.dateToDayBucket(date, vars);
        }

        long bucketToStartDate(int bucket, TimeZone timeZone) {
            TimeZoneVariables vars = PeriodUnit.getTimeZoneVariables(timeZone);
            return PeriodUnit.dayBucketToDate(bucket, vars);
        }

        long bucketToEndDate(int bucket, TimeZone timeZone) {
            TimeZoneVariables vars = PeriodUnit.getTimeZoneVariables(timeZone);
            return PeriodUnit.dayBucketToDate(bucket + 1, vars) - 1L;
        }
    };

    static final long MS_IN_1_DAY = 86400000L;
    static final long MS_IN_AVERAGE_MONTH;
    static HashMap<TimeZone, TimeZoneVariables> timeZoneVariables;

    private static TimeZoneVariables getTimeZoneVariables(TimeZone timeZone) {
        if (timeZoneVariables.containsKey(timeZone)) {
            return timeZoneVariables.get(timeZone);
        }
        TimeZoneVariables vars = new TimeZoneVariables(timeZone);
        timeZoneVariables.put(timeZone, vars);
        return vars;
    }

    private static int dateToDayBucket(long time, TimeZoneVariables vars) {
        int index = Arrays.binarySearch(vars.refDaysValues, time);
        if (index < 0) {
            index = -1 - index;
        }
        if (index > 0) {
            --index;
        }
        return (int)((double)vars.refDaysBuckets[index] + Math.floor((time - vars.refDaysValues[index]) / 86400000L));
    }

    private static long dayBucketToDate(int bucket, TimeZoneVariables vars) {
        int index = Arrays.binarySearch(vars.refDaysBuckets, bucket);
        if (index >= 0) {
            return vars.refDaysValues[index];
        }
        if ((index = -1 - index) > 0) {
            --index;
        }
        if (index > vars.refDaysBuckets.length) {
            index = vars.refDaysBuckets.length - 1;
        }
        return vars.refDaysValues[index] + (long)(bucket - vars.refDaysBuckets[index]) * 86400000L;
    }

    private static int dateToMonthBucket(long date, long[] months) {
        int index = Arrays.binarySearch(months, date);
        if (index < 0) {
            index = -(index + 2);
        }
        return index;
    }

    abstract long bucketToStartDate(int var1, TimeZone var2);

    abstract long bucketToEndDate(int var1, TimeZone var2);

    abstract int dateToBucket(long var1, TimeZone var3);

    static {
        MS_IN_AVERAGE_MONTH = Math.round(2.62800288E9);
        timeZoneVariables = new HashMap();
    }
}

