/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.bucket;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.bucket.BucketGraph;
import com.cenqua.fisheye.bucket.InfinityDBConnector;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.rep.AuthorLinecountCalculator;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.obfuscate.idbk4ui8v._Attribute;
import com.cenqua.obfuscate.idbk4ui8v._Cu;
import com.cenqua.obfuscate.idbk4ui8v._ItemSpace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;

class RevCacheReader {
    private final BucketGraph dataCollector;
    private int count = 0;
    private RepositoryStatus status;
    private final InfinityDBConnector con;
    private _ItemSpace db;
    private RevisionCache cache;

    public RevCacheReader(BucketGraph bucketGraph, RevisionCache cache, RepositoryStatus status) throws DbException {
        this.dataCollector = bucketGraph;
        this.status = status;
        this.con = this.dataCollector.getConnector();
        this.db = this.con.getDB();
        this.cache = cache;
    }

    private void updateStatusMessage(String message) {
        this.status.setMessage("Pre-calculating LOC data: " + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFromRevCache() throws DbException {
        if (!this.status.getLocLock()) {
            return;
        }
        try {
            this.updateStatusMessage("rescanning.");
            this.con.deleteAllData();
            this.con.saveTimeZone(AppConfig.getsConfig().getTimezone());
            this.con.resetAllIds();
            this.updateStatusMessage(this.count + " revisions processed");
            if (this.iterateRevIds()) {
                this.con.setVersionToCurrent();
            } else {
                this.updateStatusMessage("operation cancelled");
            }
            new AuthorLinecountCalculator(this.cache, this.status, "").calcBlame();
            this.updateStatusMessage(" finished");
        }
        finally {
            this.status.releaseLocLock();
        }
    }

    private boolean iterateRevIds() throws DbException {
        try {
            _Cu revidCursor = _Cu.alloc().append(CommonSchema.RevInfo.ENTITY);
            int revidCursorPrefixLength = revidCursor.length();
            while (this.db.next(revidCursor, revidCursorPrefixLength)) {
                if (this.status.isStopRequested()) {
                    return false;
                }
                int revid = (int)revidCursor.longAt(revidCursorPrefixLength);
                this.processRevId(revid);
                int offsetAfterKey = revidCursor.skipLong(revidCursorPrefixLength);
                revidCursor.setLength(offsetAfterKey);
                revidCursor.incrementSuffix(revidCursorPrefixLength);
            }
            this.dataCollector.commit();
            _Cu.dispose(revidCursor);
        }
        catch (IOException e2) {
            throw new DbException("Error reading database in linecount slurp", e2);
        }
        return true;
    }

    private void processRevId(int revid) throws DbException, IOException {
        _Cu dataCursor = _Cu.alloc().append(CommonSchema.RevInfo.ENTITY);
        int datap0 = dataCursor.length();
        long date = this.getDate(revid, datap0, this.db, dataCursor);
        long pathID = this.getPathID(revid, datap0, this.db, dataCursor);
        String path = UniqueStringTable.get(this.db, CommonSchema.E_PATHS, pathID);
        boolean trunklike = this.getBoolean(revid, datap0, this.db, dataCursor, CommonSchema.RevInfo.A_ISTRUNKLIKE);
        String[] branchPoints = this.getBranchPoints(revid, datap0, this.db, dataCursor);
        String author = this.getAuthor(revid, datap0, this.db, dataCursor);
        String branch = this.getBranch(revid, datap0, this.db, dataCursor);
        int[] linecount = this.getLinecount(revid, dataCursor, datap0, this.db);
        this.addData(new Path(path), branch, new Date(date), linecount[1] - linecount[2], author, trunklike);
        if (this.cache.getRepositoryType().equals("cvs")) {
            for (String branchPoint : branchPoints) {
                this.addData(new Path(path), branchPoint, new Date(date), linecount[0], author, false);
            }
        }
    }

    private int[] getLinecount(int revid, _Cu dataCursor, int datap0, _ItemSpace db) throws IOException {
        int[] result = new int[]{0, 0, 0};
        dataCursor.setLength(datap0).append(revid).append(CommonSchema.RevInfo.A_LINEDATA);
        int pl = dataCursor.length();
        if (db.next(dataCursor, pl)) {
            result[0] = (int)dataCursor.longAt(pl);
            pl = dataCursor.skipLong(pl);
            result[1] = (int)dataCursor.longAt(pl);
            pl = dataCursor.skipLong(pl);
            result[2] = (int)dataCursor.longAt(pl);
        }
        return result;
    }

    private void addData(Path dir, String branch, Date date, int lineChange, String commitAuthor, boolean isTrunklike) throws DbException {
        ++this.count;
        this.dataCollector.addRevision(dir, branch, date, lineChange, commitAuthor, isTrunklike);
        if (this.count % 500 == 0) {
            this.updateStatusMessage(this.count + " revisions processed.");
        }
    }

    private long getDate(long revid, int datap0, _ItemSpace db, _Cu dataCursor) throws IOException {
        return this.getLong(revid, datap0, db, dataCursor, CommonSchema.RevInfo.A_DATE);
    }

    private long getPathID(long revid, int datap0, _ItemSpace db, _Cu dataCursor) throws IOException {
        return this.getLong(revid, datap0, db, dataCursor, CommonSchema.RevInfo.A_REVKEY);
    }

    private String getAuthor(long revid, int datap0, _ItemSpace db, _Cu dataCursor) throws IOException {
        return this.getString(revid, datap0, db, dataCursor, CommonSchema.RevInfo.A_AUTHOR);
    }

    private String getBranch(long revid, int datap0, _ItemSpace db, _Cu dataCursor) throws IOException {
        return this.getString(revid, datap0, db, dataCursor, CommonSchema.RevInfo.A_BRANCH);
    }

    private boolean getBoolean(long revid, int datap0, _ItemSpace db, _Cu dataCursor, _Attribute attribute) throws IOException {
        boolean bool = false;
        dataCursor.setLength(datap0).append(revid).append(attribute);
        int pl = dataCursor.length();
        if (db.next(dataCursor, pl)) {
            bool = dataCursor.booleanAt(pl);
        }
        return bool;
    }

    private String getString(long revid, int datap0, _ItemSpace db, _Cu dataCursor, _Attribute attribute) throws IOException {
        String string = "";
        dataCursor.setLength(datap0).append(revid).append(attribute);
        int pl = dataCursor.length();
        if (db.next(dataCursor, pl)) {
            string = dataCursor.stringAt(pl);
        }
        return string;
    }

    private long getLong(long revid, int datap0, _ItemSpace db, _Cu dataCursor, _Attribute attribute) throws IOException {
        long value = -1L;
        dataCursor.setLength(datap0).append(revid).append(attribute);
        int pl = dataCursor.length();
        if (db.next(dataCursor, pl)) {
            value = dataCursor.longAt(pl);
        }
        return value;
    }

    private String[] getBranchPoints(long revid, int datap0, _ItemSpace db, _Cu dataCursor) throws IOException {
        dataCursor.setLength(datap0).append(revid).append(CommonSchema.RevInfo.A_BRANCH_POINTS);
        ArrayList<String> bps = new ArrayList<String>();
        int pl = dataCursor.length();
        while (db.next(dataCursor, pl)) {
            bps.add(dataCursor.stringAt(pl));
        }
        String[] bpArray = new String[bps.size()];
        bps.toArray(bpArray);
        return bpArray;
    }
}

