/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.bucket;

import com.cenqua.fisheye.bucket.BucketData;
import com.cenqua.fisheye.bucket.BucketDataCollection;
import com.cenqua.fisheye.bucket.Dir;
import com.cenqua.fisheye.bucket.ParameterSet;
import com.cenqua.fisheye.bucket.ParameterSetRetrieve;
import com.cenqua.fisheye.bucket.SumRecursion;
import com.cenqua.fisheye.rep.DbException;
import java.util.Stack;

class SumCollector {
    private final Stack<SumRecursion> stack = new Stack();
    private BucketDataCollection total = new BucketDataCollection();

    SumCollector() {
    }

    public void add(String key, BucketData value) throws DbException {
        this.total.add(key, value);
    }

    public void add(BucketDataCollection collection) throws DbException {
        this.total.add(collection);
    }

    private void addRecursion(SumRecursion rec) {
        this.stack.push(rec);
    }

    public void addRecursion(Dir element, ParameterSet parameters, int depth) {
        this.addRecursion(new SumRecursion(element, parameters, depth));
    }

    public void addRecursion(Dir element, ParameterSet parameters, int depth, String key) {
        this.addRecursion(new SumRecursion(element, parameters, depth, key));
    }

    public BucketDataCollection getBuckets(Dir element, ParameterSetRetrieve parameters) throws DbException {
        this.total = new BucketDataCollection();
        element.getBuckets(parameters, -1, this);
        while (!this.stack.empty()) {
            this.stack.pop().execute(this);
        }
        return this.total;
    }
}

