/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.bucket;

import com.cenqua.fisheye.bucket.PeriodUnit;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

class TimeZoneVariables {
    public final long[] months;
    public final int[] refDaysBuckets;
    public final long[] refDaysValues;

    public TimeZoneVariables(TimeZone timeZone) {
        GregorianCalendar cal = new GregorianCalendar(timeZone, Locale.ENGLISH);
        cal.add(1, 10);
        long endTime = cal.getTimeInMillis();
        int numMonths = (int)Math.ceil(endTime / PeriodUnit.MS_IN_AVERAGE_MONTH);
        this.months = new long[numMonths];
        cal = new GregorianCalendar(timeZone, Locale.ENGLISH);
        cal.clear();
        cal.set(1970, 0, 1, 0, 0, 0);
        for (int i2 = 0; i2 < numMonths; ++i2) {
            this.months[i2] = cal.getTimeInMillis();
            cal.add(2, 1);
        }
        cal = new GregorianCalendar(timeZone, Locale.ENGLISH);
        cal.clear();
        cal.set(1970, 0, 1, 0, 0, 0);
        while (cal.get(7) != cal.getFirstDayOfWeek()) {
            cal.add(6, -1);
        }
        ArrayList<Integer> refDaysBucketsList = new ArrayList<Integer>();
        ArrayList<Long> refDaysValuesList = new ArrayList<Long>();
        int bucket = 0;
        long value = 0L;
        while (cal.getTimeInMillis() < endTime) {
            if (value != cal.getTimeInMillis()) {
                value = cal.getTimeInMillis();
                refDaysBucketsList.add(bucket);
                refDaysValuesList.add(value);
            }
            value += 86400000L;
            ++bucket;
            cal.add(6, 1);
        }
        this.refDaysBuckets = new int[refDaysBucketsList.size()];
        this.refDaysValues = new long[refDaysValuesList.size()];
        for (int i3 = 0; i3 < this.refDaysBuckets.length; ++i3) {
            this.refDaysBuckets[i3] = (Integer)refDaysBucketsList.get(i3);
            this.refDaysValues[i3] = (Long)refDaysValuesList.get(i3);
        }
    }
}

