/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.InfinityDbUtil;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.obfuscate.idbk4ui8v._Cu;
import com.cenqua.obfuscate.idbk4ui8v._EntityClass;
import com.cenqua.obfuscate.idbk4ui8v._Schema;
import com.cenqua.obfuscate.idbk4ui8v._k4ui8vIDB;
import java.io.File;
import java.io.IOException;

public class DB0EAV {
    public static final _Schema SCHEMA = new _Schema(_Cu.alloc());
    public static final _EntityClass DBVERSION = new _EntityClass(1L);
    public static final int CURRENT_DBVERSION = 2;
    public static final _EntityClass CONSTANTS = new _EntityClass(50L);
    public static final _EntityClass FEUSER = new _EntityClass(100L);
    public static final _EntityClass INDEX_EMAIL_TO_FEUSER = new _EntityClass(101L);
    public static final _EntityClass PERSISTENT_LOGIN = new _EntityClass(102L);
    public static final _EntityClass FEGROUP = new _EntityClass(103L);
    public static final _EntityClass WATCH = new _EntityClass(200L);
    public static final _EntityClass INDEX_REP_TO_WATCH = new _EntityClass(201L);
    public static final _EntityClass INDEX_USER_TO_WATCH = new _EntityClass(202L);

    public static InfinityDbHandle open(File file) throws IOException {
        boolean newlyCreated = InfinityDbUtil.createIfNeccessary(file);
        InfinityDbHandle handle = new InfinityDbHandle(file);
        _k4ui8vIDB db = handle.open();
        if (newlyCreated) {
            DB0EAV.initialSetup(db);
        } else {
            DB0EAV.upgradeSchema(db);
        }
        return handle;
    }

    private static void upgradeSchema(_k4ui8vIDB db) throws IOException {
        _Cu cu = _Cu.alloc();
        while (true) {
            cu.clear();
            cu.append(DBVERSION);
            int pl = cu.length();
            if (!db.first(cu, pl)) {
                throw new IOException("could not determine current version of db0 schema");
            }
            int dbVersion = (int)cu.longAt(pl);
            if (dbVersion > 2) {
                throw new IOException("db version is more recent that what we support " + dbVersion);
            }
            if (dbVersion == 2) break;
            DB0EAV.upgradeSchemaFrom(db, dbVersion);
        }
    }

    private static void upgradeSchemaFrom(_k4ui8vIDB db, int dbVersion) throws IOException {
        if (dbVersion != 1) {
            throw new IOException("cannot upgrade from schema " + dbVersion);
        }
        DB0EAV.upgrade1to2(db);
        int nextVersion = 2;
        _Cu cu = _Cu.alloc().append(DBVERSION);
        int pl = cu.length();
        cu.append(nextVersion);
        db.update(cu, pl);
        db.commit();
        Logs.APP_LOG.info((Object)"upgrade done");
    }

    private static void upgrade1to2(_k4ui8vIDB db) throws IOException {
        Logs.APP_LOG.info((Object)"upgrading db0 from schema 1 to 2");
        _Cu cu = _Cu.alloc();
        while (db.next(cu)) {
            if (cu.typeAt(0) != 2) continue;
            db.delete(cu);
        }
    }

    private static void initialSetup(_k4ui8vIDB db) throws IOException {
        _Cu cu = _Cu.alloc();
        cu.append(DBVERSION).append(2L);
        db.insert(cu);
        db.commit();
    }
}

