/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.RepositoryDefaultsType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.cvsrep.CvsRepositoryConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.P4RepositoryConfig;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.PassivateManager;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RepositoryListener;
import com.cenqua.fisheye.rep.ping.PingManager;
import com.cenqua.fisheye.svn.SvnRepositoryConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryManager {
    private final Object mLock = new Object();
    private final PassivateManager passivateManager = new PassivateManager();
    private final Map<String, RepositoryHandle> mRepMap = new TreeMap<String, RepositoryHandle>();
    private ConfigDocument.Config mConfig;
    private final RepositoryListener listener = new RepositoryListener(){

        public void onRepositoryUpdate(String repositoryName) {
            AppConfig.getsConfig().getWatchManager().repositoryChanged(repositoryName);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryHandle getRepository(String name) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRepMap.get(name);
        }
    }

    public void fullShutdown() {
        for (RepositoryHandle rep : this.getHandles()) {
            Logs.APP_LOG.info((Object)("shutdown " + rep.getName()));
            rep.stop();
        }
        try {
            boolean stillStopping;
            int sleep = 100;
            int attempts = 0;
            do {
                if (++attempts > 20) {
                    Logs.APP_LOG.warn((Object)"could not shutdown some repositories after 20 attempts");
                    break;
                }
                Thread.sleep(sleep);
                sleep = Math.min(sleep * 2, 2000);
                stillStopping = false;
                for (RepositoryHandle rep : this.getHandles()) {
                    if (rep.isStopped()) continue;
                    stillStopping = true;
                }
            } while (stillStopping);
        }
        catch (InterruptedException e2) {
            Logs.APP_LOG.info((Object)"shutdown interrupted", (Throwable)e2);
        }
    }

    public void load(ConfigDocument.Config config) throws ConfigException {
        RepositoryManager.checkConfig(config);
        this.mConfig = config;
        this.passivateManager.load(this.mConfig);
        if (this.mConfig.isSetResources()) {
            PingManager.setThreadConfig(this.mConfig.getResources());
        }
        this.reloadList();
    }

    private static void checkConfig(ConfigDocument.Config config) throws ConfigException {
        RepositoryType[] reps = config.getRepositoryArray();
        HashSet<String> repnames = new HashSet<String>();
        for (RepositoryType rep : reps) {
            String name = rep.getName();
            if (repnames.contains(name)) {
                throw new ConfigException("Configuration contains duplicate <repository>, named: " + name);
            }
            repnames.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RepositoryHandle> getHandles() {
        Object object = this.mLock;
        synchronized (object) {
            return new ArrayList<RepositoryHandle>(this.mRepMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberNotStopped() {
        Object object = this.mLock;
        synchronized (object) {
            int count = 0;
            for (RepositoryHandle handle : this.mRepMap.values()) {
                if (handle.isStopped()) continue;
                ++count;
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, RepositoryHandle> getHandleMap() {
        Object object = this.mLock;
        synchronized (object) {
            return Collections.unmodifiableMap(this.mRepMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadList() throws ConfigException {
        Object object = this.mLock;
        synchronized (object) {
            RepositoryType[] repEls;
            RepositoryDefaultsType repositoryDefaults = this.mConfig.getRepositoryDefaults();
            HashSet<String> existingNames = new HashSet<String>(this.mRepMap.keySet());
            for (RepositoryType repositoryDef : repEls = this.mConfig.getRepositoryArray()) {
                String name = repositoryDef.getName();
                existingNames.remove(name);
                if (this.mRepMap.containsKey(name)) continue;
                RepositoryConfig config = this.createRepositoryConfig(repositoryDef, repositoryDefaults);
                RepositoryHandle handle = new RepositoryHandle(name, config, this.passivateManager);
                handle.addListener(this.listener);
                this.mRepMap.put(name, handle);
                if (!config.isEnabled()) continue;
                this.passivateManager.repositoryBecameRunnable(handle);
            }
            this.mRepMap.keySet().removeAll(existingNames);
        }
    }

    private RepositoryConfig parseRepositoryConfig(String repositoryName) throws ConfigException {
        RepositoryDefaultsType repositoryDefaults = this.mConfig.getRepositoryDefaults();
        RepositoryType repositoryDef = this.getRepositoryDefinition(repositoryName);
        return this.createRepositoryConfig(repositoryDef, repositoryDefaults);
    }

    private RepositoryConfig createRepositoryConfig(RepositoryType repositoryDef, RepositoryDefaultsType repositoryDefaults) throws ConfigException {
        RepositoryConfig rep;
        if (repositoryDef.isSetCvs()) {
            rep = new CvsRepositoryConfig(repositoryDef, repositoryDefaults);
        } else if (repositoryDef.isSetSvn()) {
            rep = new SvnRepositoryConfig(repositoryDef, repositoryDefaults);
        } else if (repositoryDef.isSetPerforce()) {
            rep = new P4RepositoryConfig(repositoryDef, repositoryDefaults);
        } else {
            throw new ConfigException("Could not determine repository type for " + repositoryDef.getName());
        }
        return rep;
    }

    private RepositoryType getRepositoryDefinition(String repositoryName) throws ConfigException {
        RepositoryType[] repEls;
        for (RepositoryType repositoryType : repEls = this.mConfig.getRepositoryArray()) {
            String name = repositoryType.getName();
            if (!name.equals(repositoryName)) continue;
            return repositoryType;
        }
        throw new ConfigException("Unable to find repository " + repositoryName);
    }

    public void runRepository(String name) throws RepositoryHandle.StateException, IOException, DbException, ConfigException {
        RepositoryConfig updatedConfig = this.parseRepositoryConfig(name);
        this.getRepository(name).run(updatedConfig);
    }

    public void testConnection(String name) throws ConfigException {
        RepositoryConfig config = this.parseRepositoryConfig(name);
        config.createRepositoryTester().testConnection();
    }
}

