/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import cenqua_com_licensing.atlassian.license.DefaultSIDManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.AdminConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.DB0EAV;
import com.cenqua.fisheye.config.PropertiesContainer;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.SyntaxDefinitions;
import com.cenqua.fisheye.config1.Ajp13ServerType;
import com.cenqua.fisheye.config1.BuiltInConfigType;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.HttpServerType;
import com.cenqua.fisheye.config1.LicenseType;
import com.cenqua.fisheye.config1.PropertiesType;
import com.cenqua.fisheye.config1.RepSecurityType;
import com.cenqua.fisheye.config1.RepositoryDefaultsType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.config1.SignupType;
import com.cenqua.fisheye.config1.TextIndexerType;
import com.cenqua.fisheye.config1.ViewcvsUrlMapperType;
import com.cenqua.fisheye.config1.WatchType;
import com.cenqua.fisheye.config1.WebServerType;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.license.LicenseException;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.license.LicenseLoader;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.mail.Mailer;
import com.cenqua.fisheye.perforce.client.P4Exec;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.svn.util.SvnLoader;
import com.cenqua.fisheye.syntax.Linker;
import com.cenqua.fisheye.syntax.SyntaxDefinition;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.CustomFileNameMap;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.util.XmlbeansUtil;
import com.cenqua.fisheye.web.UserProfileManager;
import com.cenqua.fisheye.web.WatchManager;
import com.cenqua.fisheye.web.util.InetAddrPort;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import java.io.File;
import java.io.IOException;
import java.net.FileNameMap;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

public class RootConfig {
    public static final String DEFAULT_CONTROL_BIND = "127.0.0.1:8078";
    private File configFile = null;
    private ConfigDocument configDoc = null;
    private final RepositoryManager mRepMgr = new RepositoryManager();
    private FileNameMap mCustomFileNameMap = null;
    private ViewCvsRemapper mViewCvsConfig = new ViewCvsRemapper();
    private Mailer mailer = null;
    private LicenseInfo mLicense;
    private String mControlBind = "127.0.0.1:8078";
    private SyntaxDefinitions mSyntaxDefinitions;
    private UserManager mUserManager;
    private UserProfileManager mUserProfileManager;
    private WatchManager mWatchManager;
    private Configuration mTemplateConfig;
    private InfinityDbHandle mDB0;
    private File db0File;
    private Object mDB0Lock = new Object();
    private TimeZone mTimeZone = TimeZone.getDefault();
    private String fallbackSiteUrl = null;
    private final Object defaultLinkerLock = new Object();
    private Linker defaultLinker = null;

    public void setConfig(ConfigDocument dummyConfig) {
        this.configDoc = dummyConfig;
    }

    public void load(File configFile) throws IOException, ConfigException {
        this.configFile = configFile.getAbsoluteFile();
        Logs.APP_LOG.info((Object)("loading config from file: " + configFile));
        LinkedList errors = new LinkedList();
        try {
            XmlOptions opts = new XmlOptions();
            opts.setErrorListener(errors);
            ConfigDocument doc = RootConfig.parseDocument(configFile, opts);
            if (!doc.validate(opts)) {
                Logs.APP_LOG.error((Object)("Errors parsing " + configFile + ":"));
                this.logXmlErrors(errors);
                throw new ConfigException("Error parsing config file (see logs): " + configFile);
            }
            this.load(doc);
        }
        catch (XmlException e2) {
            throw new ConfigException(e2);
        }
    }

    public void reload() {
        this.initTimezone(this.getConfig());
        this.reloadDefaultLinker();
    }

    public static ConfigDocument parseDocument(File configFile, XmlOptions opts) throws XmlException, IOException {
        opts.setLoadLineNumbers();
        opts.setLoadSubstituteNamespaces(RootConfig.makeExplicitNamespaces());
        ConfigDocument cd = ConfigDocument.Factory.parse(configFile, opts);
        return cd;
    }

    public static Map makeExplicitNamespaces() {
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put("", ConfigDocument.type.getDocumentElementName().getNamespaceURI());
        return nsMap;
    }

    public ConfigDocument.Config getConfig() {
        return this.configDoc.getConfig();
    }

    public ConfigDocument getConfigDocument() {
        return this.configDoc;
    }

    public synchronized void saveConfig() throws IOException {
        this.cleanupAndUpgrade(this.getConfig());
        if (this.configFile != null && this.configFile.isFile()) {
            XmlOptions opts = new XmlOptions();
            opts.setSaveImplicitNamespaces(RootConfig.makeExplicitNamespaces());
            this.configDoc.save(this.configFile, opts);
        } else {
            Logs.APP_LOG.warn((Object)"Couldn't save config file - not a file.");
        }
    }

    private void logXmlErrors(List errors) {
        for (XmlError error : errors) {
            String location = "";
            if (error.getSourceName() != null) {
                location = location + "in " + error.getSourceName() + " ";
            }
            int line = error.getLine();
            int col = error.getColumn();
            if (line != -1) {
                location = location + "at line " + line + (col == -1 ? ":" : col + ":") + " ";
            }
            Logs.APP_LOG.error((Object)(location + error.getMessage()));
        }
    }

    public void load(ConfigDocument doc) throws ConfigException, IOException {
        this.configDoc = doc;
        ConfigDocument.Config config = doc.getConfig();
        this.cleanupAndUpgrade(config);
        this.setupSID();
    }

    public void start() throws ConfigException, IOException, DbException {
        WebServerType webServer;
        ConfigDocument.Config config = this.configDoc.getConfig();
        if (config.isSetAppHome()) {
            Logs.APP_LOG.warn((Object)"The <app-home> config element is deprecated (and ignored), please remove it");
        }
        if (!AppConfig.getAppHome().isDirectory()) {
            Logs.APP_LOG.warn((Object)("could not find application directory " + AppConfig.getAppHome()));
        }
        if (!AppConfig.getInstanceDir().isDirectory()) {
            Logs.APP_LOG.warn((Object)("could not find instance directory " + AppConfig.getInstanceDir()));
        }
        if (!(webServer = this.configDoc.getConfig().getWebServer()).isSetHttp() && !webServer.isSetAjp13()) {
            throw new ConfigException("At least one of <http> or <ajp13> elements are required in a <webserver> element.");
        }
        File tmpDir = AppConfig.getTempDir();
        tmpDir.mkdirs();
        System.setProperty("java.io.tmpdir", tmpDir.getAbsolutePath());
        File fnMapFile = new File(AppConfig.getAppHome(), "raw-mime.types");
        if (fnMapFile.isFile()) {
            try {
                this.mCustomFileNameMap = new CustomFileNameMap(fnMapFile);
            }
            catch (IOException e2) {
                Logs.APP_LOG.warn((Object)("error reading " + fnMapFile), (Throwable)e2);
            }
        }
        SvnLoader.setup(config.getSvnConfig());
        if (config.isSetP4Config() && config.getP4Config().isSetP4Location()) {
            P4Exec.setupExecutable(new File(config.getP4Config().getP4Location()));
        }
        this.mSyntaxDefinitions = this.makeSyntaxDefinitions();
        this.mRepMgr.load(config);
        this.parseViewcvsMapper(config);
        this.mControlBind = config.getControlBind();
        this.initTimezone(config);
        this.mailer = new Mailer(config.getSmtp());
        this.openDB();
        this.mTemplateConfig = new Configuration();
        this.mTemplateConfig.setDirectoryForTemplateLoading(new File(AppConfig.getAppHome(), "template"));
        this.mTemplateConfig.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        this.mTemplateConfig.setURLEscapingCharset("UTF-8");
    }

    private SyntaxDefinitions makeSyntaxDefinitions() {
        File defaultDir;
        LinkedList<File> dirs = new LinkedList<File>();
        File customDir = new File(AppConfig.getInstanceDir(), "syntax");
        if (customDir.equals(defaultDir = new File(AppConfig.getAppHome(), "syntax"))) {
            dirs.add(defaultDir);
        } else {
            dirs.add(customDir);
            dirs.add(defaultDir);
        }
        return new SyntaxDefinitions(dirs);
    }

    private void initTimezone(ConfigDocument.Config config) {
        this.mTimeZone = TimeZone.getDefault();
        if (config.isSetTimezone()) {
            String tzid = config.getTimezone();
            if (DateHelper.AVAILABLE_TIMEZONE_IDS.contains(tzid)) {
                this.mTimeZone = TimeZone.getTimeZone(tzid);
            } else {
                Logs.APP_LOG.debug((Object)("Configured TZ '" + tzid + "' not found, using default."));
            }
        } else {
            Logs.APP_LOG.debug((Object)"TZ not set, using system default.");
        }
        Logs.APP_LOG.debug((Object)("Server TZ = '" + this.mTimeZone.getID() + "'"));
    }

    public void refreshLicenses() throws LicenseException {
        LicenseLoader loader = new LicenseLoader(AppConfig.getInstanceDir(), this.getConfig());
        this.mLicense = loader.updateLicensesFromXml(this.mLicense);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLicense() throws LicenseException {
        LicenseLoader loader = new LicenseLoader(AppConfig.getInstanceDir(), this.getConfig());
        try {
            this.mLicense = loader.loadAndValidate(AppConfig.isCrucible());
        }
        finally {
            if (loader.needsSave()) {
                try {
                    this.saveConfig();
                }
                catch (IOException e2) {
                    Logs.APP_LOG.warn((Object)"Failed to save config.xml after loading application license(s)", (Throwable)e2);
                }
            }
        }
    }

    public RepositoryManager getRepositoryManager() {
        return this.mRepMgr;
    }

    public void startRepositories() {
        if (this.mLicense != null) {
            for (RepositoryHandle rep : this.mRepMgr.getHandles()) {
                try {
                    if (!rep.getCfg().isEnabled()) continue;
                    this.mRepMgr.runRepository(rep.getName());
                }
                catch (Exception e2) {
                    Logs.APP_LOG.warn((Object)"problem starting repository ", (Throwable)e2);
                }
            }
        } else {
            Logs.APP_LOG.warn((Object)"No license info available, not starting FishEye repositories.");
        }
    }

    public LicenseInfo getLicense() {
        return this.mLicense;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public Object getDB0Lock() {
        return this.mDB0Lock;
    }

    public File getDB0File() {
        return this.db0File;
    }

    private void parseViewcvsMapper(ConfigDocument.Config config) {
        if (config.isSetViewcvsUrlMapper()) {
            ViewcvsUrlMapperType e2 = config.getViewcvsUrlMapper();
            if (e2.isSetDefaultrep()) {
                this.mViewCvsConfig.setDefault(e2.getDefaultrep());
            }
            for (ViewcvsUrlMapperType.Map mapping : e2.getMapArray()) {
                this.mViewCvsConfig.add(mapping.getRep(), mapping.getViewcvsname());
            }
        }
    }

    public SyntaxDefinitions getSyntaxDefinitions() {
        return this.mSyntaxDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadDefaultLinker() {
        Object object = this.defaultLinkerLock;
        synchronized (object) {
            this.defaultLinker = null;
        }
    }

    public Linker getDefaultLinker() {
        return this.getDefaultLinker(this.getConfig().getRepositoryDefaults());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Linker getDefaultLinker(RepositoryDefaultsType defaults) {
        Object object = this.defaultLinkerLock;
        synchronized (object) {
            if (this.defaultLinker == null) {
                SyntaxDefinition url;
                this.defaultLinker = new Linker();
                SyntaxDefinition repDefaultsLinker = RepositoryConfig.parseCommentFormatter(defaults.getLinker());
                this.defaultLinker.addHighlighter(repDefaultsLinker);
                if (this.mSyntaxDefinitions != null && (url = this.mSyntaxDefinitions.getByFileName("url.def")) != null) {
                    this.defaultLinker.addHighlighter(url);
                }
                if (AppConfig.isCrucible() && !AppConfig.isTestMode()) {
                    this.defaultLinker.addHighlighter(AppConfig.getCrucibleBridge().getPermalinkLinker());
                }
                if (this.defaultLinker.isEmpty()) {
                    this.defaultLinker.addHighlighter(SyntaxDefinition.PASS_THRU);
                }
            }
            return this.defaultLinker;
        }
    }

    public boolean isApiEnabled() {
        return this.getConfig().getApi().getEnabled();
    }

    public FileNameMap getRawMimeMap() {
        return new FileNameMap(){

            public String getContentTypeFor(String fileName) {
                if (RootConfig.this.mCustomFileNameMap != null) {
                    return RootConfig.this.mCustomFileNameMap.getContentTypeFor(fileName);
                }
                return null;
            }
        };
    }

    public Mailer getMailer() {
        return this.mailer;
    }

    private void cleanupAndUpgrade(ConfigDocument.Config config) {
        RepositoryType[] reps;
        RepSecurityType defSec;
        RepositoryDefaultsType defaults;
        if (!config.isSetSecurity()) {
            SecurityType sec = config.addNewSecurity();
            sec.setAllowAnon(true);
        }
        if (!config.getSecurity().isSetBuiltIn()) {
            BuiltInConfigType bi = config.getSecurity().addNewBuiltIn();
            XmlbeansUtil.placeOnNewLine(bi, 2);
            SignupType signup = bi.addNewSignup();
            XmlbeansUtil.placeOnNewLine(signup, 3);
            signup.setEnabled(false);
        }
        if (!config.isSetLicense()) {
            LicenseType node = config.addNewLicense();
            XmlbeansUtil.placeOnNewLine(node, 1);
        }
        if (!(defaults = config.getRepositoryDefaults()).isSetSecurity()) {
            defaults.addNewSecurity();
        }
        if (!defaults.isSetTextIndexer()) {
            TextIndexerType ti = defaults.addNewTextIndexer();
            ti.setEnabled(true);
        }
        if (!defaults.isSetWatches()) {
            WatchType wt = defaults.addNewWatches();
            wt.setEnabled(true);
        }
        if (!(defSec = defaults.getSecurity()).isSetAllowAnon()) {
            defSec.setAllowAnon(true);
        }
        if (!defSec.isSetRequiredGroups()) {
            defSec.addNewRequiredGroups();
        }
        for (RepositoryType rep : reps = config.getRepositoryArray()) {
            if (!rep.isSetSecurity()) {
                rep.addNewSecurity();
                XmlbeansUtil.placeOnNewLine(rep.getSecurity(), 6);
            }
            if (rep.getSecurity().isSetRequiredGroups()) continue;
            rep.getSecurity().addNewRequiredGroups();
        }
        WebServerType ws = config.getWebServer();
        HttpServerType wsHttp = ws.getHttp();
        if (wsHttp != null && wsHttp.isSetContext()) {
            if (!ws.isSetContext()) {
                ws.setContext(wsHttp.getContext());
                wsHttp.unsetContext();
            } else {
                Logs.APP_LOG.warn((Object)"context ignored in <http> since it is set in <web-server>");
                wsHttp.unsetContext();
            }
        }
        if (wsHttp != null) {
            if (wsHttp.isSetMaxThreads()) {
                if (ws.isSetMaxThreads()) {
                    Logs.APP_LOG.warn((Object)"max-threads in <http> ignored since it is set in <web-server>");
                } else {
                    ws.setMaxThreads(wsHttp.getMaxThreads());
                }
                wsHttp.unsetMaxThreads();
            }
            if (wsHttp.isSetMinThreads()) {
                if (ws.isSetMinThreads()) {
                    Logs.APP_LOG.warn((Object)"min-threads in <http> ignored since it is set in <web-server>");
                } else {
                    ws.setMinThreads(wsHttp.getMinThreads());
                }
                wsHttp.unsetMinThreads();
            }
        }
        if (ws.isSetAjp13()) {
            Ajp13ServerType ajp13 = ws.getAjp13();
            if (ajp13.isSetMaxThreads()) {
                if (ws.isSetMaxThreads()) {
                    Logs.APP_LOG.warn((Object)"max-threads in <ajp13> ignored since it is set in <web-server>");
                } else {
                    ws.setMaxThreads(ajp13.getMaxThreads());
                }
                ajp13.unsetMaxThreads();
            }
            if (ajp13.isSetMinThreads()) {
                if (ws.isSetMinThreads()) {
                    Logs.APP_LOG.warn((Object)"min-threads in <ajp13> ignored since it is set in <web-server>");
                } else {
                    ws.setMinThreads(ajp13.getMinThreads());
                }
                ajp13.unsetMinThreads();
            }
        }
    }

    public ViewCvsRemapper getViewCvsRemapper() {
        return this.mViewCvsConfig;
    }

    public String getControlBind() {
        return this.mControlBind;
    }

    public AdminConfig getAdminConfig() {
        return new AdminConfig(this.getConfig());
    }

    public UserManager getUserManager() {
        return this.mUserManager;
    }

    public UserProfileManager getUserProfileManager() {
        return this.mUserProfileManager;
    }

    public WatchManager getWatchManager() {
        return this.mWatchManager;
    }

    public Configuration getTemplateConfig() {
        return this.mTemplateConfig;
    }

    public TimeZone getTimezone() {
        return this.mTimeZone;
    }

    public String getSiteURL(HttpServletRequest request) {
        String siteurl = (String)request.getAttribute("siteurl");
        if (siteurl == null) {
            siteurl = this.getSiteURL();
        }
        return siteurl;
    }

    public String getSiteURL() {
        WebServerType ws = this.getConfig().getWebServer();
        if (ws.isSetSiteUrl()) {
            String url = ws.getSiteUrl().trim();
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            return url;
        }
        if (this.fallbackSiteUrl == null && ws.isSetHttp()) {
            StringBuffer url = this.getUrlFromHttpType(ws);
            this.fallbackSiteUrl = url.toString();
        }
        return this.fallbackSiteUrl;
    }

    private StringBuffer getUrlFromHttpType(WebServerType ws) {
        char lastc;
        if (!ws.isSetHttp()) {
            Logs.APP_LOG.info((Object)"No <HTTP> element in <webserver> element.");
            return new StringBuffer();
        }
        StringBuffer url = new StringBuffer(48);
        HttpServerType http = ws.getHttp();
        String scheme = http.isSetProxyScheme() ? http.getProxyScheme() : "http";
        url.append(scheme);
        url.append("://");
        String servername = null;
        int port = 80;
        try {
            InetAddrPort bind = new InetAddrPort(http.getBind());
            if (!"0.0.0.0".equals(bind.getHost())) {
                servername = bind.getHost();
            }
            port = bind.getPort();
        }
        catch (Exception e2) {
            Logs.APP_LOG.info((Object)"problem parsing our own bind address", (Throwable)e2);
        }
        if (http.isSetProxyHost()) {
            servername = http.getProxyHost();
        }
        if (servername == null) {
            servername = RootConfig.guessLocalhost();
        }
        url.append(servername);
        if (http.isSetProxyPort()) {
            port = http.getProxyPort().intValue();
        }
        if (port > 0 && (scheme.equalsIgnoreCase("http") && port != 80 || scheme.equalsIgnoreCase("https") && port != 443)) {
            url.append(':');
            url.append(port);
        }
        if (ws.isSetContext()) {
            String ctx = ws.getContext();
            if (!ctx.startsWith("/")) {
                url.append("/");
            }
            url.append(ctx);
        }
        if ((lastc = url.charAt(url.length() - 1)) != '/') {
            url.append("/");
        }
        return url;
    }

    private static String guessLocalhost() {
        try {
            return InetAddress.getLocalHost().getHostName().toLowerCase();
        }
        catch (Exception ex) {
            return "localhost";
        }
    }

    public void fullShutdown() {
        this.closeDB();
        this.mRepMgr.fullShutdown();
    }

    public void closeDB() {
        if (this.mWatchManager != null) {
            this.mWatchManager.stop();
            this.mWatchManager = null;
        }
        if (this.mDB0 != null) {
            try {
                this.mDB0.close();
            }
            catch (IOException e2) {
                Logs.APP_LOG.warn((Object)("problem closing db0 " + e2.getMessage()));
            }
        }
    }

    public void openDB() throws DbException, ConfigException {
        if (this.mDB0 == null) {
            try {
                this.db0File = new File(AppConfig.getDataDir(), "data0.bin");
                this.mDB0 = DB0EAV.open(this.db0File);
                this.mUserManager = new UserManager(this.mDB0, this.mDB0Lock, this.getConfig());
                this.mUserProfileManager = new UserProfileManager(this.mDB0, this.mDB0Lock);
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
        }
        this.mDB0.get();
        if (this.mWatchManager == null) {
            this.mWatchManager = new WatchManager(this.mDB0, this.mDB0Lock);
        }
    }

    public static PropertiesContainer asPropertiesContainer(final ConfigDocument.Config delegate) {
        return new PropertiesContainer(){

            public boolean isSetProperties() {
                return delegate.isSetProperties();
            }

            public PropertiesType getProperties() {
                return delegate.getProperties();
            }

            public void unsetProperties() {
                delegate.unsetProperties();
            }

            public PropertiesType addNewProperties() {
                return delegate.addNewProperties();
            }
        };
    }

    private void setupSID() throws ConfigException {
        try {
            LicenseType l = this.getConfig().getLicense();
            if (l.isSetSID()) {
                return;
            }
            Logs.APP_LOG.debug((Object)"Setting SID on first-run.");
            DefaultSIDManager sidMgr = new DefaultSIDManager();
            String sid = sidMgr.generateSID();
            Logs.APP_LOG.debug((Object)("SID set to " + sid));
            l.setSID(sid);
            this.saveConfig();
            Logs.APP_LOG.debug((Object)"SID saved to config.xml");
        }
        catch (Exception e2) {
            Logs.APP_LOG.info((Object)"SID problem", (Throwable)e2);
            throw new ConfigException("Problem initializing config file.Please make sure this file is writable: " + this.configFile);
        }
    }

    public class ViewCvsRemapper {
        private final Map mNameMap = new HashMap();
        private String mDefault = null;

        public String getDefaultRepository() {
            if (this.mDefault != null) {
                return this.mDefault;
            }
            List<RepositoryHandle> reps = RootConfig.this.mRepMgr.getHandles();
            if (reps.isEmpty()) {
                return "UNKNOWN";
            }
            return reps.get(0).getName();
        }

        void setDefault(String aDefault) {
            this.mDefault = aDefault;
        }

        void add(String repname, String viewcvsName) {
            this.mNameMap.put(viewcvsName, repname);
        }

        public String map(String viewcvsName) {
            String name = (String)this.mNameMap.get(viewcvsName);
            return name != null ? name : viewcvsName;
        }
    }
}

