/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.ctl;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class InstanceLock {
    private final FileOutputStream lockStream;

    private InstanceLock(FileOutputStream lockStream) {
        this.lockStream = lockStream;
    }

    public void release() {
        IOHelper.close(this.lockStream);
    }

    public static InstanceLock acquireLock() {
        FileOutputStream lockStream;
        File parent = AppConfig.getVarDir();
        if (!parent.exists() && !parent.mkdirs()) {
            Logs.APP_LOG.error((Object)("Had problem creating directory " + parent));
        }
        File lockFile = new File(parent, "fisheye.lck");
        try {
            lockStream = new FileOutputStream(lockFile);
        }
        catch (FileNotFoundException e2) {
            Logs.APP_LOG.error((Object)("Could not open " + lockFile + " : " + e2.getMessage()));
            return null;
        }
        FileChannel fc = lockStream.getChannel();
        try {
            FileLock fl = fc.tryLock();
            if (fl == null) {
                IOHelper.close(lockStream);
                Logs.APP_LOG.error((Object)("Lock already locked " + lockFile));
                return null;
            }
        }
        catch (IOException ix) {
            Logs.APP_LOG.warn((Object)("Exclusive lock probably not supported on " + lockFile + " : " + ix.getMessage()));
            Logs.APP_LOG.warn((Object)"Multiple FishEye instance prevention disabled.");
        }
        return new InstanceLock(lockStream);
    }
}

