/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import antlr.Token;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RcsStringToken
extends Token {
    private final long mStart;
    private final long mEnd;

    public RcsStringToken(long aFp0, long aFp1) {
        super(13);
        this.mStart = aFp0;
        this.mEnd = aFp1;
    }

    public long getStart() {
        return this.mStart;
    }

    public long getEnd() {
        return this.mEnd;
    }

    public InputStream getInputStream(BufferedRandomAccessInputStream aFile) throws IOException {
        aFile.mark();
        StringParserInputStream stream = new StringParserInputStream(aFile, this.mEnd - this.mStart);
        aFile.seek(this.mStart);
        return stream;
    }

    public static class StringParserInputStream
    extends InputStream {
        private final BufferedRandomAccessInputStream mStream;
        private final long mFullLen;
        private long mCount = 0L;

        public StringParserInputStream(BufferedRandomAccessInputStream aStream, long aFullLen) {
            this.mStream = aStream;
            this.mFullLen = aFullLen;
        }

        public int read() throws IOException {
            int c2;
            if (this.mCount == 0L) {
                c2 = this.mStream.read();
                ++this.mCount;
                if (c2 != 64) {
                    this.mCount = this.mFullLen;
                    throw new IOException("expected @ as first character in string, was " + (char)c2);
                }
            }
            boolean escaping = false;
            do {
                if (this.mCount >= this.mFullLen) {
                    return -1;
                }
                c2 = this.mStream.read();
                if (c2 == -1) {
                    return -1;
                }
                ++this.mCount;
                if (c2 != 64) continue;
                boolean bl = escaping = !escaping;
            } while (escaping);
            return c2;
        }

        public void close() throws IOException {
            this.mStream.reset();
        }
    }
}

