/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import com.cenqua.fisheye.cvsrep.AbstractRCSParseListener;
import com.cenqua.fisheye.cvsrep.DiffParser;
import com.cenqua.fisheye.cvsrep.KeywordExpandingLineWriter;
import com.cenqua.fisheye.cvsrep.KeywordExpansion;
import com.cenqua.fisheye.cvsrep.LineWriter;
import com.cenqua.fisheye.cvsrep.RCSParser;
import com.cenqua.fisheye.cvsrep.RcsStringToken;
import com.cenqua.fisheye.cvsrep.RcsUtil;
import com.cenqua.fisheye.cvsrep.Revision;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.io.LineReader;
import com.cenqua.fisheye.io.StreamLineReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class RevisionExtractor
extends AbstractRCSParseListener {
    private final BufferedRandomAccessInputStream mFile;
    private final Revision mWantedRevision;
    private final LineWriter mOut;
    private final Charset mCharSet;
    private Revision mHead;
    private Revision mCurrentRevision;
    private Revision mNextRevision;
    private Revision mNext;
    private Revision mBranch;
    private boolean mFound;
    private List<Revision> mDiffSequence = new ArrayList<Revision>();
    private List<String> mInMemoryDiff = new ArrayList<String>();

    private RevisionExtractor(BufferedRandomAccessInputStream file, Charset cs, Revision wantedRevision, LineWriter out) {
        this.mFile = file;
        this.mCharSet = cs;
        this.mWantedRevision = wantedRevision;
        this.mOut = out;
    }

    public static void extractRevision(BufferedRandomAccessInputStream aFile, Charset cs, Revision aRev, LineWriter aDest) throws IOException, RCSParser.ParseException {
        RevisionExtractor extractor = new RevisionExtractor(aFile, cs, aRev, aDest);
        aFile.seek(0L);
        RCSParser.parse(aFile, cs, extractor);
    }

    public void adminHead(String num) {
        this.mHead = new Revision(num);
    }

    public void adminExpand(RcsStringToken t) throws TokenStreamException {
        KeywordExpandingLineWriter lw;
        if (this.mOut instanceof KeywordExpandingLineWriter && (lw = (KeywordExpandingLineWriter)this.mOut).getExpand() == null) {
            String k = RcsUtil.rcsStringToString(t, this.mCharSet, this.mFile).toString();
            KeywordExpansion kopt = KeywordExpansion.parse(k);
            lw.setExpand(kopt);
        }
    }

    public void endAdmin() {
        this.mCurrentRevision = null;
        this.mNextRevision = null;
        this.mFound = false;
        this.mDiffSequence.clear();
        this.mDiffSequence.add(this.mHead);
    }

    public void startDelta(String num, String date, String author) {
        if (!this.mFound) {
            this.mCurrentRevision = new Revision(num);
            this.mNext = null;
            this.mBranch = null;
            if (this.mCurrentRevision.equals(this.mWantedRevision)) {
                this.mFound = true;
                return;
            }
        }
    }

    public void deltaNext(String num) {
        if (!this.mFound) {
            this.mNext = new Revision(num);
        }
    }

    public void deltaBranch(String num) {
        Revision branch;
        if (!this.mFound && (branch = new Revision(num)).commonPrefixCount(this.mWantedRevision) >= branch.getNumCount() - 1) {
            this.mBranch = branch;
        }
    }

    public void endDelta() {
        if (!this.mFound) {
            if (this.mNextRevision == null) {
                if (this.mBranch != null) {
                    this.mDiffSequence.add(this.mBranch);
                    this.mNextRevision = this.mBranch;
                } else if (this.mNext != null) {
                    this.mDiffSequence.add(this.mNext);
                    this.mNextRevision = this.mNext;
                } else {
                    this.mNextRevision = this.mNext;
                }
            } else if (this.mBranch != null) {
                this.mDiffSequence.add(this.mBranch);
                this.mNextRevision = this.mBranch;
            } else if (this.mNextRevision.equals(this.mCurrentRevision)) {
                this.mDiffSequence.add(this.mNext);
                this.mNextRevision = this.mNext;
            }
        }
    }

    public void endDeltaSection() {
        if (!this.mFound) {
            this.stopParsing();
        }
    }

    public void startDeltatext(String num) {
        this.mCurrentRevision = new Revision(num);
    }

    public void deltatextText(RcsStringToken text) throws TokenStreamIOException {
        if (this.mDiffSequence.size() > 0) {
            if (this.mCurrentRevision.equals(this.mDiffSequence.get(0))) {
                try {
                    if (this.mCurrentRevision.equals(this.mHead)) {
                        this.slurpHead(text);
                    } else {
                        this.applyDiff(text);
                    }
                }
                catch (IOException e2) {
                    throw new TokenStreamIOException(e2);
                }
                this.mDiffSequence.remove(0);
                if (this.mDiffSequence.isEmpty()) {
                    this.outputResult();
                }
            }
        } else {
            this.stopParsing();
        }
    }

    private void outputResult() throws TokenStreamIOException {
        try {
            for (String s : this.mInMemoryDiff) {
                this.mOut.writeLine(s);
            }
        }
        catch (IOException e2) {
            throw new TokenStreamIOException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyDiff(RcsStringToken aText) throws IOException {
        InputStream in = null;
        try {
            in = aText.getInputStream(this.mFile);
            LineReader lr = this.makeLineReader(in);
            DiffParser dp = new DiffParser(lr);
            DiffApplicator patcher = new DiffApplicator();
            dp.parseHunks(patcher);
        }
        catch (Throwable throwable) {
            IOHelper.close(in);
            throw throwable;
        }
        IOHelper.close(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int slurpHead(RcsStringToken aText) throws IOException {
        int n;
        InputStream in = null;
        try {
            String line;
            in = aText.getInputStream(this.mFile);
            LineReader reader = this.makeLineReader(in);
            int count = 0;
            while ((line = reader.readLine()) != null) {
                this.mInMemoryDiff.add(line);
                ++count;
            }
            n = count;
        }
        catch (Throwable throwable) {
            IOHelper.close(in);
            throw throwable;
        }
        IOHelper.close(in);
        return n;
    }

    private LineReader makeLineReader(InputStream in) {
        return new StreamLineReader(LineReader.Mode.MODE_UNIX, in);
    }

    private class DiffApplicator
    implements DiffParser.DiffListener {
        int offset = 0;
        int addLine;

        private DiffApplicator() {
        }

        public void delete(int line, int count) {
            int pos = line + this.offset - 1;
            RevisionExtractor.this.mInMemoryDiff.subList(pos, pos + count).clear();
            this.offset -= count;
        }

        public void startAdd(int line, int count) {
            this.addLine = line + this.offset - 1;
        }

        public void addLine(String line) {
            if (this.addLine < 0) {
                RevisionExtractor.this.mInMemoryDiff.add(0, line);
            } else {
                int pos = this.addLine + 1;
                RevisionExtractor.this.mInMemoryDiff.add(pos, line);
            }
            ++this.offset;
            ++this.addLine;
        }
    }
}

