/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.quicksearch;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cvsrep.quicksearch.QuickSearchResults;
import com.cenqua.fisheye.cvsrep.quicksearch.QuickSearcher;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.web.UrlHelper;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsidQuickSearch
implements QuickSearcher.SearchAlgorithm {
    private final RevisionCache cache;
    private final String repname;

    public CsidQuickSearch(QuickSearcher searcher) {
        RepositoryEngine eng = searcher.getEngine();
        this.cache = eng.getRevisionCache();
        this.repname = eng.getName();
    }

    @Override
    public QuickSearchResults.TermResults search(Path path, List<String> params) throws IOException, DbException {
        if (params.isEmpty()) {
            return null;
        }
        QuickSearchResults.TermResults matches = new QuickSearchResults.TermResults();
        HashSet<String> foundIds = new HashSet<String>();
        for (String term : params) {
            String csid;
            ChangeSet cs = this.cache.getChangeSet(term);
            if (cs != null && cs.getRevisionInfosCount() != 0 && !foundIds.contains(csid = cs.getId())) {
                foundIds.add(csid);
                matches.addMatch(cs, 1);
            }
            for (String csid2 : this.cache.findSimilarPartialChangeSetIds(term)) {
                if (foundIds.contains(csid2)) continue;
                foundIds.add(csid2);
                matches.addMatch(this.cache.getChangeSet(csid2), 1);
            }
            for (String csid2 : this.cache.getSimilarChangeSetIds(term)) {
                if (foundIds.contains(csid2)) continue;
                foundIds.add(csid2);
                matches.addMatch(this.cache.getChangeSet(csid2), 1);
            }
        }
        if (foundIds.size() == 1) {
            String csid = (String)foundIds.iterator().next();
            UrlHelper url = new UrlHelper();
            url.setUrl("/changelog/" + this.repname);
            url.getParams().put("cs", csid);
            matches.setExactMatchRedirect(url);
        }
        return matches;
    }
}

