/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.search;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Filter;

public abstract class CustomStringFilter
extends Filter {
    protected final String mField;

    public CustomStringFilter(String field) {
        this.mField = field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitSet bits(IndexReader reader) throws IOException {
        BitSet bits = new BitSet(reader.maxDoc());
        String startTerm = this.getStartTerm();
        TermEnum enumerator = reader.terms(new Term(this.mField, startTerm));
        TermDocs termDocs = reader.termDocs();
        try {
            Term stop;
            if (enumerator.term() == null) {
                BitSet bitSet = bits;
                return bitSet;
            }
            String end = this.getEndTerm();
            Term term = stop = end != null ? new Term(this.mField, end) : null;
            while (end == null || enumerator.term().compareTo(stop) <= 0) {
                Term t = enumerator.term();
                if (!t.field().equals(this.mField)) {
                } else {
                    if (this.matches(t.text())) {
                        termDocs.seek(enumerator.term());
                        while (termDocs.next()) {
                            bits.set(termDocs.doc());
                        }
                    }
                    if (enumerator.next()) continue;
                }
                break;
            }
        }
        finally {
            enumerator.close();
            termDocs.close();
        }
        return bits;
    }

    protected abstract boolean matches(String var1);

    protected String getStartTerm() {
        return "";
    }

    protected String getEndTerm() {
        return null;
    }
}

