/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff.view;

import com.cenqua.fisheye.diff.EDiff;
import com.cenqua.fisheye.diff.Section;
import com.cenqua.fisheye.diff.view.DiffPrinter;
import com.cenqua.fisheye.diff.view.SectionView;
import com.cenqua.fisheye.syntax.RegionList;
import java.io.IOException;

public class LinePair {
    private final DiffPrinter printer;
    private final SectionView sectionView;
    private final boolean startOfSection;
    private final Line from;
    private final Line to;
    private EDiff ediff;

    public LinePair(DiffPrinter printer, SectionView sectionView, boolean startOfSection, Integer fromLine, Integer toLine) {
        this.printer = printer;
        this.sectionView = sectionView;
        this.startOfSection = startOfSection;
        this.from = fromLine == null ? null : new Line(fromLine, true);
        this.to = toLine == null ? null : new Line(toLine, false);
    }

    public SectionView getSectionView() {
        return this.sectionView;
    }

    public Section getSection() {
        return this.sectionView.getSection();
    }

    public boolean isStartOfSection() {
        return this.startOfSection;
    }

    public boolean isInFirstSection() {
        return this.sectionView == this.printer.getFirstSectionView();
    }

    public boolean isInLastSection() {
        return this.sectionView == this.printer.getLastSectionView();
    }

    public Line getFrom() {
        return this.from;
    }

    public Line getTo() {
        return this.to;
    }

    public boolean getShowFrom() {
        if (this.printer.isUnified() && this.getSection().isCommonSubsequence()) {
            return false;
        }
        return this.from != null;
    }

    public boolean getShowTo() {
        return this.to != null;
    }

    public boolean getHasEdiff() {
        return this.ediff != null;
    }

    public EDiff getEdiff() {
        return this.ediff;
    }

    void setEdiff(EDiff ediff) {
        this.ediff = ediff;
    }

    public int getFromLineNumberEquiv() {
        return this.from != null ? this.from.getLineNumber() : this.getSection().getFromStart();
    }

    public int getToLineNumberEquiv() {
        return this.to != null ? this.to.getLineNumber() : this.getSection().getToStart();
    }

    public class Line {
        private final int lineNumber;
        private final boolean isFrom;
        private CharSequence line;

        public Line(int lineNumber, boolean from) {
            this.lineNumber = lineNumber;
            this.isFrom = from;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public CharSequence getLine() {
            if (this.line == null) {
                this.line = this.isFrom ? LinePair.this.sectionView.getFromLine(this.lineNumber) : LinePair.this.sectionView.getToLine(this.lineNumber);
            }
            return this.line;
        }

        public RegionList getStyleRegions() throws IOException {
            RegionList regions = LinePair.this.ediff != null ? (this.isFrom ? LinePair.this.ediff.getOriginalRegions() : LinePair.this.ediff.getRevisedRegions()) : new RegionList();
            int offset = this.isFrom ? LinePair.this.sectionView.getFromLineOffset(this.lineNumber) : LinePair.this.sectionView.getToLineOffset(this.lineNumber);
            regions = regions.getSubset(offset, offset + this.getLine().length());
            regions.translate(-offset);
            RegionList syntaxHighlightRegions = this.isFrom ? LinePair.this.sectionView.getFromLineSyntaxHighlights(this.lineNumber) : LinePair.this.sectionView.getToLineSyntaxHighlights(this.lineNumber);
            syntaxHighlightRegions.translate(-offset);
            regions.merge(syntaxHighlightRegions);
            return regions;
        }
    }
}

