/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb.query3;

import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.bitset.SegmentedIntSet;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import com.cenqua.obfuscate.idbk4ui8v._Cu;
import com.cenqua.obfuscate.idbk4ui8v._ItemSpace;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;

public abstract class Query3 {
    public _ItemSpace asItemSpace(final _ItemSpace source, LuceneConnection conn) throws DbException {
        boolean withLucene;
        TIntHashSet requiredReaders = new TIntHashSet();
        this.calculateRequiredReaders(requiredReaders);
        boolean bl = withLucene = !requiredReaders.isEmpty();
        if (withLucene && conn == null) {
            throw new DbException("Query requires lucene but no connection given: " + this.toString());
        }
        final Query3 q = this.simplify();
        if (!withLucene) {
            return q.asItemSpace(source, (IndexReader[])null);
        }
        final _ItemSpace[] result = new _ItemSpace[1];
        conn.withReader(requiredReaders, new LuceneConnection.ReaderActionN(){

            public void perform(IndexReader[] readers) throws DbException {
                result[0] = q.asItemSpace(source, readers);
            }
        });
        return result[0];
    }

    protected abstract void calculateRequiredReaders(TIntHashSet var1);

    protected abstract _ItemSpace asItemSpace(_ItemSpace var1, IndexReader[] var2) throws DbException;

    public SortedIntSet collectMatchingRevids(_ItemSpace db, LuceneConnection conn) throws DbException {
        try {
            SegmentedIntSet bs = new SegmentedIntSet();
            _ItemSpace result = this.asItemSpace(db, conn);
            _Cu cu = _Cu.alloc();
            while (result.next(cu)) {
                int revid = (int)cu.longAt(0);
                bs.set(revid);
            }
            return bs;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public int countMatches(_ItemSpace db, LuceneConnection conn) throws DbException {
        try {
            int count = 0;
            _ItemSpace result = this.asItemSpace(db, conn);
            _Cu cu = _Cu.alloc();
            while (result.next(cu)) {
                ++count;
            }
            return count;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public boolean existAny(_ItemSpace db, LuceneConnection conn) throws DbException {
        try {
            _ItemSpace result = this.asItemSpace(db, conn);
            _Cu cu = _Cu.alloc();
            return result.next(cu);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public String toString() {
        StringBuffer s = new StringBuffer();
        this.toString(s);
        return s.toString();
    }

    public abstract void toString(StringBuffer var1);

    public Query3 simplify() {
        return this;
    }

    public static SortedIntSet makeBitSet() {
        return new SegmentedIntSet();
    }
}

