/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce.client;

import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.perforce.client.P4FileSpec;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4ChangePath {
    public static final String FILETYPE_UNKNOWN = "unknown";
    private P4FileSpec fileSpec;
    private String action;
    private int added;
    private int removed;
    private String fileType = "unknown";
    private String integrationAction;
    private P4FileSpec sourceFileSpec;
    private long fileSize;
    private List<Hunk> hunks = null;

    public P4ChangePath(P4FileSpec fileSpec) {
        this.fileSpec = fileSpec;
    }

    public String getPath() {
        return this.fileSpec.getPath();
    }

    public String getAction() {
        return this.action;
    }

    public void incAdded(int i2) {
        this.added += i2;
    }

    public void incRemoved(int i2) {
        this.removed += i2;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getFileType() {
        return this.fileType;
    }

    public int getAdded() {
        return this.added;
    }

    public int getRemoved() {
        return this.removed;
    }

    public int getFileRev() {
        return this.fileSpec.getFileRev();
    }

    public void setSourceInfo(String integrationAction, P4FileSpec sourceFileSpec) {
        this.integrationAction = integrationAction;
        this.sourceFileSpec = sourceFileSpec;
    }

    public String toString() {
        String result = this.fileSpec.toString() + " " + this.action + " " + this.fileType;
        if (this.integrationAction != null) {
            result = result + " " + this.integrationAction + " from " + this.sourceFileSpec;
        }
        return result;
    }

    public P4FileSpec getFileSpec() {
        return this.fileSpec;
    }

    public P4FileSpec getSourceFileSpec() {
        return this.sourceFileSpec;
    }

    public String getIntegrationAction() {
        return this.integrationAction;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public boolean isBinary() {
        String type = this.fileType.toLowerCase();
        return !type.matches(".*(text|unicode|utf16).*");
    }

    public void addHunk(Hunk hunk) {
        if (this.hunks == null) {
            this.hunks = new ArrayList<Hunk>();
        }
        if (this.hunks.isEmpty()) {
            this.hunks.add(hunk);
        } else {
            int lastIndex = this.hunks.size() - 1;
            Hunk lastHunk = this.hunks.get(lastIndex);
            if (lastHunk.isDelete() && hunk.isAdd() && lastHunk.getFrom() == hunk.getTo()) {
                this.hunks.remove(lastIndex);
                int fromCount = lastHunk.getFromCount() + hunk.getFromCount();
                int toCount = lastHunk.getToCount() + hunk.getToCount();
                Hunk combinedHunk = new Hunk(lastHunk.getFrom(), hunk.getTo(), fromCount, toCount);
                this.hunks.add(combinedHunk);
            } else {
                this.hunks.add(hunk);
            }
        }
    }

    public List<Hunk> getHunks() {
        return this.hunks;
    }
}

