/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce.client;

import com.cenqua.fisheye.logging.Logs;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4CliUtils {
    private static final int STATE_WHITESPACE = 1;
    private static final int STATE_INQUOTE = 2;
    private static final int STATE_INVALUE = 3;

    public static List<String> tokenizeCommand(String line) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuffer currentElement = new StringBuffer();
        int state = 1;
        int length = line.length();
        block5: for (int i2 = 0; i2 < length; ++i2) {
            char ch = line.charAt(i2);
            switch (state) {
                case 1: {
                    if (Character.isWhitespace(ch)) continue block5;
                    if (ch == '\"') {
                        currentElement.setLength(0);
                        state = 2;
                        continue block5;
                    }
                    state = 3;
                    currentElement.setLength(0);
                    currentElement.append(ch);
                    continue block5;
                }
                case 3: {
                    if (Character.isWhitespace(ch)) {
                        state = 1;
                        tokens.add(currentElement.toString());
                        continue block5;
                    }
                    currentElement.append(ch);
                    continue block5;
                }
                case 2: {
                    if (ch == '\"') {
                        state = 1;
                        tokens.add(currentElement.toString());
                        continue block5;
                    }
                    currentElement.append(ch);
                }
            }
        }
        if (state != 1) {
            tokens.add(currentElement.toString());
        }
        return tokens;
    }

    public static void dumpCommandLine(String descriptor, List<String> args) {
        if (Logs.APP_LOG.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            for (String arg : args) {
                buf.append(arg);
                buf.append(' ');
            }
            Logs.APP_LOG.debug((Object)(descriptor + " Executing " + buf.toString()));
        }
    }

    public static String getCommandLine(String[] args) {
        StringBuffer buf = new StringBuffer();
        for (String arg : args) {
            buf.append(arg);
            buf.append(' ');
        }
        return buf.toString();
    }

    public static String getWord(String line, ParsePosition pos) {
        String result;
        int index;
        int length = line.length();
        for (index = pos.getIndex(); index < length && Character.isSpaceChar(line.charAt(index)); ++index) {
        }
        if (index == length) {
            result = null;
        } else {
            int firstCharIndex = index++;
            while (index < length && !Character.isSpaceChar(line.charAt(index))) {
                ++index;
            }
            result = index == length ? line.substring(firstCharIndex) : line.substring(firstCharIndex, index);
        }
        pos.setIndex(index);
        return result;
    }

    public static List<String> getLineElements(String line) {
        ArrayList<String> elements = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(line);
        while (tokenizer.hasMoreElements()) {
            elements.add((String)tokenizer.nextElement());
        }
        return elements;
    }

    public static String[] getWords(String line, ParsePosition pos, int numWords) {
        String[] result = new String[numWords];
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = P4CliUtils.getWord(line, pos);
        }
        return result;
    }

    public static String getWord(String text) {
        return P4CliUtils.getWord(text, new ParsePosition(0));
    }
}

