/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce.client;

import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.P4RepositoryInfo;
import com.cenqua.fisheye.perforce.client.P4CliUtils;
import com.cenqua.fisheye.perforce.client.P4ClientException;
import com.cenqua.fisheye.perforce.client.P4FieldProcessor;
import com.cenqua.fisheye.perforce.client.P4OutputLineProcessor;
import com.cenqua.fisheye.perforce.client.P4OutputProcessor;
import com.cenqua.fisheye.perforce.client.P4Process;
import com.cenqua.fisheye.perforce.client.P4Processor;
import com.cenqua.fisheye.perforce.client.P4Visitor;
import com.cenqua.fisheye.perforce.client.P4ZTagProcessor;
import com.cenqua.fisheye.util.Throttle;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4Exec {
    private static final int BUF_SIZE = 1024;
    private static final int DEFAULT_LOGIN_TIMEOUT = 30000;
    private static final int DEFAULT_EXEC_TIMEOUT = 600000;
    private static final int MAX_FIELD_SIZE = 50000;
    private static String p4Executable = "p4";
    private List<String> commandRoot;
    private Throttle throttle;
    private boolean requiresLogin;
    private P4RepositoryInfo repoInfo;
    private final long loginCommandTimeout;
    private final long execCommandTimeout;
    private String encoding = null;
    private volatile Thread executingThread;
    private volatile P4Process currentProcess;

    public static void setP4Executable(String executable) {
        p4Executable = executable;
    }

    public static String getP4Executable() {
        return p4Executable;
    }

    public P4Exec(P4RepositoryInfo repoInfo, Throttle throttle) throws P4ClientException {
        this.throttle = throttle;
        this.repoInfo = repoInfo;
        if (repoInfo.getCommandTimeout() != 0L) {
            this.loginCommandTimeout = repoInfo.getCommandTimeout();
            this.execCommandTimeout = repoInfo.getCommandTimeout();
        } else {
            this.loginCommandTimeout = 30000L;
            this.execCommandTimeout = 600000L;
        }
        this.setup();
    }

    private void setup() throws P4ClientException {
        this.commandRoot = new ArrayList<String>();
        this.commandRoot.add(p4Executable);
        this.commandRoot.add("-p");
        this.commandRoot.add(this.repoInfo.getServer() + ":" + this.repoInfo.getPort());
        if (this.repoInfo.isUnicode()) {
            this.commandRoot.add("-C");
            this.commandRoot.add("utf8");
            this.encoding = "UTF-8";
        }
        if (this.repoInfo.getUsername() != null) {
            this.commandRoot.add("-u");
            this.commandRoot.add(this.repoInfo.getUsername());
            if (this.repoInfo.getPassword() != null) {
                this.requiresLogin = true;
            }
        }
    }

    public String login() {
        String status = null;
        if (this.requiresLogin) {
            ArrayList<String> commandArgs = new ArrayList<String>(this.commandRoot);
            commandArgs.add("login");
            P4CliUtils.dumpCommandLine("[" + this.repoInfo.getRepositoryDescriptor() + "]", commandArgs);
            String[] args = commandArgs.toArray(new String[commandArgs.size()]);
            P4Process process = new P4Process(args, this.repoInfo.getPassword(), this.loginCommandTimeout, this.encoding){

                protected void processOutput(InputStream is) throws IOException, P4ClientException {
                    is.close();
                }
            };
            try {
                this.startProcess(process);
                status = this.finishProcess(process);
                if (status != null) {
                    status = "Unable to login: " + status;
                }
            }
            catch (Throwable e2) {
                Logs.APP_LOG.warn((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Exception when logging in"), e2);
                status = "Unable to login: " + e2.getClass().getName() + ":" + e2.getMessage();
            }
        }
        return status;
    }

    private String executeStreamCommand(String[] cmdArray, String input, final P4Visitor.ProcessOutputVisitor visitor) throws P4ClientException {
        P4Process process = new P4Process(cmdArray, input, this.execCommandTimeout, this.encoding){

            protected void processOutput(InputStream is) throws IOException, P4ClientException {
                visitor.visit(this, is);
            }
        };
        this.startProcess(process);
        return this.finishProcess(process);
    }

    private String executeStreamCommand(String[] cmdArray, String input, OutputStream out) throws P4ClientException {
        String exitStatus = null;
        PipedInputStream pis = new PipedInputStream();
        try {
            final PipedOutputStream pos = new PipedOutputStream(pis);
            P4Process process = new P4Process(cmdArray, input, this.execCommandTimeout, this.encoding){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void processOutput(InputStream is) throws IOException, P4ClientException {
                    byte[] buffer = new byte[1024];
                    BufferedInputStream bis = null;
                    try {
                        int numRead;
                        bis = new BufferedInputStream(is);
                        while ((numRead = bis.read(buffer)) >= 0) {
                            pos.write(buffer, 0, numRead);
                        }
                        pos.flush();
                    }
                    catch (Throwable throwable) {
                        IOHelper.close(bis);
                        IOHelper.close(pos);
                        throw throwable;
                    }
                    IOHelper.close(bis);
                    IOHelper.close(pos);
                }
            };
            this.startProcess(process);
            IOHelper.copyStream((InputStream)pis, out);
            exitStatus = this.finishProcess(process);
        }
        catch (IOException e2) {
            throw new P4ClientException(e2);
        }
        finally {
            IOHelper.close(pis);
        }
        return exitStatus;
    }

    private String processCommand(String[] cmdArray, String input, P4OutputProcessor processor) throws P4ClientException {
        String exitStatus = this.rawProcessCommand(cmdArray, input, processor);
        if (exitStatus != null && this.requiresLogin) {
            Logs.APP_LOG.debug((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Command failed with status = " + exitStatus + " - retrying with fresh login"));
            exitStatus = this.login();
            if (exitStatus == null) {
                exitStatus = this.rawProcessCommand(cmdArray, input, processor);
            }
        }
        return exitStatus;
    }

    private String rawProcessCommand(String[] cmdArray, String input, final P4OutputProcessor processor) throws P4ClientException {
        P4Process process = new P4Process(cmdArray, input, this.execCommandTimeout, this.encoding){

            protected void processOutput(InputStream is) throws IOException, P4ClientException {
                processor.processOutput(this, is);
            }

            protected String complete(String exitStatus) throws P4ClientException {
                return processor.complete(exitStatus);
            }
        };
        this.startProcess(process);
        return this.finishProcess(process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProcess(P4Process process) throws P4ClientException {
        P4Exec p4Exec = this;
        synchronized (p4Exec) {
            this.throttle.apply();
            this.executingThread = Thread.currentThread();
            this.currentProcess = process;
            process.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String finishProcess(P4Process process) throws P4ClientException {
        String status = process.finish();
        P4Exec p4Exec = this;
        synchronized (p4Exec) {
            this.currentProcess = null;
            this.executingThread = null;
            return status;
        }
    }

    private String[] setUpCommand(List<String> command, String commandInput, P4Processor processor) {
        ArrayList<String> commandArgs = new ArrayList<String>(this.commandRoot);
        if (processor != null && processor.getFormatOption() != null) {
            commandArgs.add(processor.getFormatOption());
        }
        if (commandInput != null) {
            commandArgs.add("-x");
            commandArgs.add("-");
            Logs.APP_LOG.debug((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Command input: " + commandInput));
        }
        commandArgs.addAll(command);
        P4CliUtils.dumpCommandLine("[" + this.repoInfo.getRepositoryDescriptor() + "]", commandArgs);
        String[] args = commandArgs.toArray(new String[commandArgs.size()]);
        return args;
    }

    public String executeAndStream(List<String> command, String input, OutputStream out) throws P4ClientException {
        String[] args = this.setUpCommand(command, input, null);
        String exitStatus = this.executeStreamCommand(args, input, out);
        if (exitStatus != null && this.requiresLogin && (exitStatus = this.login()) == null) {
            exitStatus = this.executeStreamCommand(args, input, out);
        }
        return exitStatus;
    }

    public String executeAndStream(List<String> command, String input, P4Visitor.ProcessOutputVisitor visitor) throws P4ClientException {
        String[] args = this.setUpCommand(command, input, null);
        String exitStatus = this.executeStreamCommand(args, input, visitor);
        if (exitStatus != null && this.requiresLogin && (exitStatus = this.login()) == null) {
            exitStatus = this.executeStreamCommand(args, input, visitor);
        }
        return exitStatus;
    }

    public String executeCommand(List<String> command, P4OutputProcessor processor) throws P4ClientException {
        String[] cmdArray = this.setUpCommand(command, null, processor);
        return this.processCommand(cmdArray, null, processor);
    }

    public String executeFieldCommand(List<String> command, final boolean streamFieldLines, final P4FieldProcessor processor) throws P4ClientException {
        String[] cmdArray = this.setUpCommand(command, null, processor);
        return this.processCommand(cmdArray, null, new P4OutputLineProcessor(this.encoding){
            private String fieldName;
            private String fieldValue;

            public void processLine(String line) {
                if (line.startsWith("#")) {
                    return;
                }
                if (line.startsWith("\t") && this.fieldName != null) {
                    if (streamFieldLines) {
                        this.processField();
                        this.fieldValue = line.substring(1);
                    } else if (this.fieldValue != null) {
                        this.fieldValue = this.fieldValue + "\n";
                        this.fieldValue = this.fieldValue + line.substring(1);
                    } else {
                        this.fieldValue = line.substring(1);
                    }
                } else if (line.trim().length() != 0) {
                    this.processField();
                    int colonIndex = line.indexOf(58);
                    if (colonIndex != -1) {
                        this.fieldName = line.substring(0, colonIndex);
                        this.fieldValue = line.length() >= colonIndex + 2 ? line.substring(colonIndex + 2) : null;
                    }
                }
            }

            public String complete(String exitStatus) {
                this.processField();
                return exitStatus;
            }

            private void processField() {
                if (this.fieldName != null && this.fieldValue != null) {
                    processor.processField(this.fieldName, this.fieldValue);
                }
                this.fieldValue = null;
            }
        });
    }

    public String executeZTagCommand(List<String> command, String keyTag, P4ZTagProcessor processor) throws P4ClientException {
        return this.executeWithInput(command, null, keyTag, processor);
    }

    public String executeWithInput(List<String> command, String commandInput, final String keyTag, final P4ZTagProcessor processor) throws P4ClientException {
        String[] cmdArray = this.setUpCommand(command, commandInput, processor);
        return this.processCommand(cmdArray, commandInput, new P4OutputLineProcessor(this.encoding){
            private Map<String, String> currentGroup;
            private String currentKey;
            private StringBuilder otherOutput;
            {
                super(x0);
                this.currentGroup = null;
                this.currentKey = null;
                this.otherOutput = new StringBuilder();
            }

            public void processLine(String ztagLine) throws P4ClientException {
                if (ztagLine.trim().length() == 0) {
                    return;
                }
                if (keyTag == null && this.currentGroup == null) {
                    this.currentGroup = new HashMap<String, String>();
                }
                if (ztagLine.startsWith("... ")) {
                    String line = ztagLine.substring(4);
                    ParsePosition pos = new ParsePosition(0);
                    this.currentKey = P4CliUtils.getWord(line, pos);
                    if (pos.getIndex() < line.length()) {
                        String value = line.substring(pos.getIndex() + 1);
                        if (keyTag != null && this.currentKey.equals(keyTag)) {
                            if (this.currentGroup != null) {
                                processor.processGroup(this.currentGroup);
                            }
                            this.currentGroup = new HashMap<String, String>();
                        }
                        if (this.currentGroup != null) {
                            this.currentGroup.put(this.currentKey, value);
                        }
                    }
                } else if (this.currentKey != null && this.currentGroup != null) {
                    String currentValue = this.currentGroup.get(this.currentKey);
                    if (currentValue == null) {
                        currentValue = "";
                    }
                    if (currentValue.length() < 50000) {
                        if ((currentValue = currentValue + "\n" + ztagLine).length() > 50000) {
                            currentValue = currentValue.substring(0, 50000);
                        }
                        this.currentGroup.put(this.currentKey, currentValue);
                    }
                } else {
                    this.otherOutput.append(ztagLine).append('\n');
                }
            }

            public String complete(String exitStatus) throws P4ClientException {
                if (exitStatus != null) {
                    exitStatus = exitStatus + " : " + this.otherOutput.toString();
                }
                if (this.currentGroup != null) {
                    processor.processGroup(this.currentGroup);
                }
                this.currentGroup = null;
                return exitStatus;
            }
        });
    }

    public static void setupExecutable(File p4ExecutableFile) throws ConfigException {
        if (!p4ExecutableFile.exists()) {
            throw new ConfigException("P4 executable does not exist at configured location: " + p4ExecutableFile.getAbsolutePath());
        }
        P4Exec.setP4Executable(p4ExecutableFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        while (this.currentProcess != null) {
            try {
                P4Exec p4Exec = this;
                synchronized (p4Exec) {
                    if (this.currentProcess != null) {
                        this.currentProcess.cancel();
                        Thread.sleep(10000L);
                        this.executingThread.interrupt();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

