/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce.db;

import com.cenqua.fisheye.rep.impl.CommonFileRevision;
import com.cenqua.fisheye.rep.impl.CommonFileRevisionInput;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4RevInfo
extends CommonFileRevision
implements CommonFileRevisionInput {
    private long p4ChangeSetId;
    private int fileRev;
    private long fileSize;
    private Set<String> fixes = new HashSet<String>();
    private boolean unicode;
    private String p4FileType;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        P4RevInfo p4RevInfo = (P4RevInfo)o;
        if (this.p4ChangeSetId != p4RevInfo.p4ChangeSetId) {
            return false;
        }
        return this.getPath().equals(p4RevInfo.getPath());
    }

    public int hashCode() {
        int result = (int)(this.p4ChangeSetId ^ this.p4ChangeSetId >>> 32);
        result = 31 * result + this.getPath().hashCode();
        return result;
    }

    public void setP4ChangeSetId(long p4ChangeSetId) {
        this.p4ChangeSetId = p4ChangeSetId;
        super.setRevision(Long.toString(p4ChangeSetId));
    }

    @Override
    public void setRevision(String revision) {
        super.setRevision(revision);
        this.p4ChangeSetId = Long.parseLong(revision);
    }

    public long getP4ChangeSetId() {
        return this.p4ChangeSetId;
    }

    public void setFileRev(int fileRev) {
        this.fileRev = fileRev;
    }

    public int getFileRev() {
        return this.fileRev;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void addFix(String jobName) {
        this.fixes.add(jobName);
    }

    public Set<String> getFixes() {
        return this.fixes;
    }

    public void setFixes(Set<String> fixes) {
        this.fixes = fixes;
    }

    public void setUnicode(boolean unicode) {
        this.unicode = unicode;
    }

    public boolean isUnicode() {
        return this.unicode;
    }

    public void setP4FileType(String p4FileType) {
        this.p4FileType = p4FileType;
    }

    public String getP4FileType() {
        return this.p4FileType;
    }
}

