/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce.db;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.P4ChangeSet;
import com.cenqua.fisheye.perforce.client.P4Job;
import com.cenqua.fisheye.perforce.db.P4RevInfo;
import com.cenqua.fisheye.perforce.db.P4Schema;
import com.cenqua.fisheye.perforce.db.P4StringTables;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DirInfo;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonDirInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.util.bitset.SegmentedIntSet;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import com.cenqua.obfuscate.idbk4ui8v._Cu;
import com.cenqua.obfuscate.idbk4ui8v._ItemSpace;
import com.cenqua.obfuscate.idbk4ui8v._k4ui8vIDB;
import gnu.trove.TIntArrayList;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4RevInfoDAO {
    private final CommonRevInfoDAO commonDAO;
    private final CommonDirInfoDAO dirDAO;
    private final CommonStringTables commonStringTables;
    private final InfinityDbHandle dbh;
    private final P4StringTables p4StringTables;

    public P4RevInfoDAO(InfinityDbHandle dbh, P4StringTables p4StringTables, CommonStringTables stringTables, boolean caseSensitive) {
        this.dbh = dbh;
        this.p4StringTables = p4StringTables;
        this.commonStringTables = stringTables;
        this.commonDAO = new CommonRevInfoDAO(dbh, this.commonStringTables, false, caseSensitive, false);
        this.dirDAO = new CommonDirInfoDAO(dbh, this.commonStringTables, caseSensitive);
    }

    public RevInfoKey getKey(int revid) throws DbException {
        return this.commonDAO.getKey(revid);
    }

    public int insertNew(P4RevInfo revInfo, AncestorLink ancestorLink, boolean storeDiffs) throws DbException {
        int revid = this.commonDAO.insertNew(revInfo, ancestorLink, storeDiffs);
        this.commonDAO.addRevidLongIndex(P4Schema.I_CHANGESETID_REVID, revInfo.getP4ChangeSetId(), revid);
        this.commonDAO.addPathLongProperty(P4Schema.I_PATHID_CHANGESETID, revInfo.getPath(), revInfo.getP4ChangeSetId());
        long pathId = this.commonDAO.getPathId(revInfo.getPath());
        this.commonDAO.addRevIdLongProperty(P4Schema.I_REVID_TO_PATHID, revid, pathId);
        this.commonDAO.addRevIdLongProperty(P4Schema.A_FILESIZE, revid, revInfo.getFileSize());
        this.commonDAO.addRevIdLongProperty(P4Schema.A_FILEREV, revid, revInfo.getFileRev());
        this.commonDAO.addRevIdLongProperty(P4Schema.A_UNICODE, revid, revInfo.isUnicode() ? 1L : 0L);
        long fileTypeId = this.p4StringTables.p4NamesDB.add(revInfo.getP4FileType());
        this.commonDAO.addRevIdLongProperty(P4Schema.A_P4FILETYPE, revid, fileTypeId);
        this.storeFileRevisionInfo(revInfo, revid);
        this.storeFixes(revInfo, revid);
        return revid;
    }

    public long findJobId(String jobName) throws DbException {
        return this.p4StringTables.p4NamesDB.find(jobName);
    }

    private void storeFixes(P4RevInfo revInfo, int revid) throws DbException {
        _Cu cu = _Cu.alloc();
        try {
            _k4ui8vIDB db = this.dbh.get();
            for (String jobName : revInfo.getFixes()) {
                long jobId = this.createJobId(jobName);
                cu.clear().append(P4Schema.I_REVID_TO_JOBID).append(revid).append(jobId);
                ((_ItemSpace)db).insert(cu);
                cu.clear().append(P4Schema.I_JOBID_TO_REVID).append(jobId).append(revid);
                ((_ItemSpace)db).insert(cu);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private long createJobId(String jobName) throws DbException {
        return this.p4StringTables.p4NamesDB.add(jobName);
    }

    public Set<String> getFixes(int revid) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            HashSet<String> result = new HashSet<String>();
            _Cu cu = _Cu.alloc().append(P4Schema.I_REVID_TO_JOBID).append(revid);
            int keyLength = cu.length();
            while (((_ItemSpace)db).next(cu, keyLength)) {
                long jobId = cu.longAt(keyLength);
                String jobName = this.p4StringTables.p4NamesDB.get(jobId);
                result.add(jobName);
            }
            return result;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void storeFileRevisionInfo(P4RevInfo revInfo, int revid) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            long pathId = this.commonDAO.getPathId(revInfo.getPath());
            if (pathId == -1L) {
                throw new DbException("Unable to find path " + revInfo.getPath() + ", not in database");
            }
            _Cu cu = _Cu.alloc().append(P4Schema.I_PATHID_FILEREV_REVID);
            cu.append(pathId).append(revInfo.getFileRev()).append(revid);
            ((_ItemSpace)db).insert(cu);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public int getRevIdByFileRev(Path path, int fileRev) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            _Cu cu = _Cu.alloc().append(P4Schema.I_PATHID_FILEREV_REVID);
            long pathId = this.commonDAO.getPathId(path);
            int revid = -1;
            if (pathId != -1L) {
                cu.append(pathId).append(fileRev);
                int keyLength = cu.length();
                if (((_ItemSpace)db).next(cu, keyLength)) {
                    revid = (int)cu.longAt(keyLength);
                }
            }
            return revid;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public SortedIntSet getRevidsInChangeSetRange(long fromCSID, long toCSID) throws DbException {
        return this.commonDAO.getRevidsInLongIndexRange(P4Schema.I_CHANGESETID_REVID, fromCSID, toCSID);
    }

    public P4RevInfo load(int revId) throws DbException {
        P4RevInfo revInfo = null;
        if (this.commonDAO.exists(revId)) {
            try {
                String fileType;
                revInfo = new P4RevInfo();
                this.commonDAO.load(revId, revInfo);
                revInfo.setFileSize(this.commonDAO.getLongProperty(P4Schema.A_FILESIZE, revId, 0L));
                revInfo.setFileRev((int)this.commonDAO.getLongProperty(P4Schema.A_FILEREV, revId, 0L));
                revInfo.setUnicode(this.commonDAO.getLongProperty(P4Schema.A_UNICODE, revId, 0L) == 1L);
                long fileTypeId = this.commonDAO.getLongProperty(P4Schema.A_P4FILETYPE, revId, -1L);
                if (fileTypeId != -1L && (fileType = this.p4StringTables.p4NamesDB.get(fileTypeId)) != null) {
                    revInfo.setP4FileType(fileType);
                }
                revInfo.setFixes(this.getFixes(revId));
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)e2);
                revInfo = null;
            }
        }
        return revInfo;
    }

    public ChangeSet loadChangeSet(long p4id) throws DbException {
        TIntArrayList revids = this.commonDAO.getIndexedRevIds(P4Schema.I_CHANGESETID_REVID, p4id);
        P4ChangeSet changeSet = null;
        if (revids.size() != 0) {
            changeSet = new P4ChangeSet(this);
            changeSet.init(revids);
        }
        return changeSet;
    }

    public SortedMap<Long, Integer> getPathRevisions(Path path) throws DbException {
        return this.commonDAO.getPathRevisions(path);
    }

    public long getLatestPathChange(Path path) throws DbException {
        return this.commonDAO.getPathLargestProperty(P4Schema.I_PATHID_CHANGESETID, path, -1L, -1L);
    }

    public int getLatestPathRevid(Path path) throws DbException {
        long latestPathChangeRev = this.getLatestPathChange(path);
        int revid = -1;
        if (latestPathChangeRev != -1L) {
            revid = this.getRevId(path, latestPathChangeRev);
        }
        return revid;
    }

    public int getRevId(Path path, long p4id) throws DbException {
        int revid = -1;
        long pathId = this.commonDAO.getPathId(path);
        if (pathId != -1L) {
            revid = this.commonDAO.getRevId(pathId, Long.toString(p4id));
        }
        return revid;
    }

    public void addPathRevIds(SegmentedIntSet revids, int pathId) throws DbException {
        this.commonDAO.addPathRevIds(revids, pathId);
    }

    public int getFileType(int revid) throws DbException {
        return this.commonDAO.getFileType(revid);
    }

    public int getLineCount(int revid) throws DbException {
        return this.commonDAO.getLineCount(revid);
    }

    public CommonRevInfoDAO getCommonRevInfoDAO() {
        return this.commonDAO;
    }

    public SortedIntSet getPaths(SortedIntSet revids) throws DbException {
        return this.commonDAO.getLongProperySet(P4Schema.I_REVID_TO_PATHID, revids);
    }

    public Path getPath(long pathId) throws DbException {
        return new Path(this.commonStringTables.pathDB.get(pathId));
    }

    public String getBranch(int revid) throws DbException {
        return this.commonDAO.getBranchOf(revid);
    }

    public boolean isDeleted(int revid) throws DbException {
        return this.commonDAO.isDeleted(revid);
    }

    public long getTagUpdateTime(String tag) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            long tagid = this.commonStringTables.tagDB.find(tag);
            if (tagid == -1L) {
                return -1L;
            }
            _Cu cu = _Cu.alloc().append(P4Schema.E_TAG_TIME);
            cu.append(tagid);
            int pl = cu.length();
            long updateTime = -1L;
            if (((_ItemSpace)db).next(cu, pl)) {
                updateTime = cu.longAt(pl);
            }
            return updateTime;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void setTagUpdateTime(String tag, long updateTime) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            long tagid = this.commonStringTables.tagDB.add(tag);
            _Cu cu = _Cu.alloc().append(P4Schema.E_TAG_TIME);
            cu.append(tagid);
            int pl = cu.length();
            cu.append(updateTime);
            ((_ItemSpace)db).update(cu, pl);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void removeTag(String tag) throws DbException {
        this.commonDAO.removeTag(tag);
    }

    public void addTag(int revid, String tag) throws DbException {
        this.commonDAO.addTagData(revid, tag);
    }

    public DirInfo getDirInfo(Path dir) throws DbException {
        return this.dirDAO.load(dir);
    }

    public boolean existsDir(Path dir) throws DbException {
        return this.dirDAO.exists(dir);
    }

    public void createDir(Path dir) throws DbException {
        try {
            this.dirDAO.addDirToParent(dir);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateLineCount(RevInfoKey key, int lineCount, int linesAdded, int linesRemoved) throws DbException {
        this.commonDAO.updateLineCount(key, this.load(this.commonDAO.getRevId(key)), lineCount, linesAdded, linesRemoved);
    }

    public void updateJob(P4Job job) throws DbException {
        Logs.APP_LOG.debug((Object)("Updating Job " + job.getName()));
        try {
            _k4ui8vIDB db = this.dbh.get();
            long jobId = this.createJobId(job.getName());
            _Cu cu = _Cu.alloc().append(P4Schema.E_JOBS);
            cu.append(jobId);
            int pk = cu.length();
            String description = job.getDescription();
            if (description == null) {
                description = "";
            }
            long descriptionId = this.p4StringTables.p4JobStringsDB.add(description);
            cu.append(descriptionId);
            ((_ItemSpace)db).update(cu, pk);
            this.removeJobFields(db, cu, jobId);
            this.addJobFields(db, cu, jobId, job.getFields());
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public P4Job loadJob(String jobName) throws DbException {
        long jobId = this.findJobId(jobName);
        if (jobId == -1L) {
            return null;
        }
        P4Job job = null;
        try {
            _k4ui8vIDB db = this.dbh.get();
            _Cu cu = _Cu.alloc().append(P4Schema.E_JOBS);
            cu.append(jobId);
            int pk = cu.length();
            if (((_ItemSpace)db).next(cu, pk)) {
                String description = this.getP4JobStringAt(cu, pk);
                Map<String, String> fields = this.loadJobFields(db, cu, jobId);
                job = new P4Job(jobName, description, fields);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        return job;
    }

    private String getP4JobStringAt(_Cu cu, int pk) throws DbException {
        String result;
        if (cu.typeAt(pk) == 7) {
            long stringId = cu.longAt(pk);
            result = this.p4StringTables.p4JobStringsDB.get(stringId);
        } else {
            result = cu.stringAt(pk);
        }
        return result;
    }

    private Map<String, String> loadJobFields(_ItemSpace db, _Cu cu, long jobId) throws DbException {
        HashMap<String, String> fields = new HashMap<String, String>();
        try {
            cu.clear().append(jobId);
            int pk = cu.length();
            while (db.next(cu, pk)) {
                long fieldNameId = cu.longAt(pk);
                int offset = cu.skipLong(pk);
                String fieldValue = this.getP4JobStringAt(cu, offset);
                String fieldName = this.p4StringTables.p4NamesDB.get(fieldNameId);
                if (fieldName == null) continue;
                fields.put(fieldName, fieldValue);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        return fields;
    }

    private void addJobFields(_ItemSpace db, _Cu cu, long jobId, Map<String, String> fields) throws DbException {
        try {
            cu.clear().append(jobId);
            int pk = cu.length();
            for (Map.Entry<String, String> entry : fields.entrySet()) {
                long fieldId = this.p4StringTables.p4NamesDB.add(entry.getKey());
                String value = entry.getValue();
                if (value != null) {
                    long valueId = this.p4StringTables.p4JobStringsDB.add(value);
                    cu.append(fieldId).append(valueId);
                    db.insert(cu);
                }
                cu.setLength(pk);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void removeJobFields(_ItemSpace db, _Cu cu, long jobId) throws DbException {
        try {
            cu.clear().append(jobId);
            int pk = cu.length();
            while (db.next(cu, pk)) {
                db.delete(cu);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void addHunk(RevInfoKey key, Hunk hunk) throws DbException {
        try {
            int revid = this.commonDAO.getRevId(key);
            List<Hunk> hunkList = Collections.singletonList(hunk);
            this.commonDAO.setHunks(revid, hunkList);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }
}

