/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChangeSet {
    public abstract String getComment();

    public abstract long getDate();

    public Date getDateValue() {
        return new Date(this.getDate());
    }

    public abstract String getAuthor();

    public abstract String getBranch() throws DbException;

    public abstract int getRevisionInfosCount() throws DbException;

    public Iterator<FileRevision> getRevisionInfos() throws DbException {
        final int revInfoCount = this.getRevisionInfosCount();
        Iterator<FileRevision> iterator = new Iterator<FileRevision>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < revInfoCount;
            }

            @Override
            public FileRevision next() {
                try {
                    return ChangeSet.this.getRevisionInfo(this.idx++);
                }
                catch (DbException e2) {
                    Logs.APP_LOG.warn((Object)"unexpected db exception", (Throwable)e2);
                    return null;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return iterator;
    }

    public abstract Iterator<RevInfoKey> getRevisionInfoKeys() throws DbException;

    public abstract FileRevision getRevisionInfo(int var1) throws DbException;

    public abstract String getId();

    public abstract Set getReviewIds() throws DbException;
}

