/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.PassivateManager;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryEventMulticaster;
import com.cenqua.fisheye.rep.RepositoryListener;
import com.cenqua.fisheye.rep.RepositoryPinger;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.ping.CrucibleIncrementalRequest;
import com.cenqua.fisheye.rep.ping.CrucibleReindexRequest;
import com.cenqua.fisheye.rep.ping.LinecountReindexRequest;
import com.cenqua.fisheye.rep.ping.OneOffPingRequest;
import com.cenqua.fisheye.rep.ping.PingRequest;
import com.cenqua.fisheye.rep.ping.RescanRequest;
import com.cenqua.fisheye.util.Disposable;
import com.cenqua.fisheye.util.Disposer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class RepositoryHandle {
    public static final int STATE_STOPPED = 0;
    public static final int STATE_RUNNING = 1;
    public static final int STATE_STOPPING = 2;
    public static final int STATE_STARTING = 4;
    private static final long INITIAL_PING_DELAY = 2000L;
    private final PassivateManager passivateManager;
    private final String name;
    private RepositoryConfig cfg;
    private RepositoryEngine engine;
    private volatile int mState = 0;
    private final Object mLock = new Object();
    private int mAcquireCount = 0;
    private boolean needsPassivation = false;
    private boolean mDisableBackgroundUpdaterOnInit = false;
    private final RepositoryEventMulticaster eventMulticaster = new RepositoryEventMulticaster();
    private RepositoryPinger pinger;
    private final List<PingRequest> queuedRequests = new ArrayList<PingRequest>();
    private boolean indexing = false;
    private long lastModified = AppConfig.START_TIME;

    public RepositoryHandle(String name, RepositoryConfig config, PassivateManager passivateManager) throws ConfigException {
        this.name = name;
        this.cfg = config;
        this.passivateManager = passivateManager;
        this.pinger = new RepositoryPinger(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queuePingRequest(PingRequest request) {
        List<PingRequest> list = this.queuedRequests;
        synchronized (list) {
            for (PingRequest queued : this.queuedRequests) {
                if (!queued.canCombine(request)) continue;
                queued.combine(request);
                return;
            }
            this.queuedRequests.add(request);
            if (this.indexing) {
                return;
            }
            this.indexing = true;
        }
        this.processPingRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPingRequests() {
        try {
            PingRequest request;
            while ((request = this.getNextPingRequest()) != null) {
                if (!this.indexing) {
                    throw new IllegalStateException("Indexing cannot be performed without locking repository handle");
                }
                request.process();
            }
        }
        finally {
            this.indexing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PingRequest getNextPingRequest() {
        List<PingRequest> list = this.queuedRequests;
        synchronized (list) {
            if (this.queuedRequests.isEmpty()) {
                return null;
            }
            return this.queuedRequests.remove(0);
        }
    }

    public void addListener(RepositoryListener l) {
        this.eventMulticaster.addListener(l);
    }

    public void removeListener(RepositoryListener l) {
        this.eventMulticaster.removeListener(l);
    }

    public String getName() {
        return this.name;
    }

    public boolean isDisableBackgroundUpdaterOnInit() {
        return this.mDisableBackgroundUpdaterOnInit;
    }

    public void setDisableBackgroundUpdaterOnInit(boolean disableBackgroundUpdaterOnInit) {
        this.mDisableBackgroundUpdaterOnInit = disableBackgroundUpdaterOnInit;
    }

    public boolean isRunning() {
        return this.mState == 1;
    }

    public boolean isStopped() {
        return this.mState == 0;
    }

    public boolean isStopping() {
        return this.mState == 2;
    }

    public boolean isStarting() {
        return this.mState == 4;
    }

    public String getStateDescription() {
        String description;
        switch (this.mState) {
            case 1: {
                description = "Running";
                break;
            }
            case 2: {
                description = "Stopping";
                break;
            }
            case 0: {
                description = "Stopped";
                break;
            }
            case 4: {
                description = "Starting";
                break;
            }
            default: {
                description = "UNKNOWN";
            }
        }
        return description;
    }

    public boolean tryStop(long timeout) {
        this.stop();
        long end = System.currentTimeMillis() + timeout;
        do {
            if (this.isStopped()) {
                return true;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e2) {
                break;
            }
        } while (System.currentTimeMillis() <= end);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isStopped() || this.isStopping()) {
                return;
            }
            this.mState = 2;
            this.getStatus().setStopRequested(true);
            this.engine.requestStop();
            Logs.APP_LOG.info((Object)("STOP requested on " + this.name));
            this.passivateManager.repositoryNoLongerRunnable(this);
            this.tryToBeginStopProcedure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RepositoryConfig config) throws StateException, ConfigException, DbException, IOException {
        this.cfg = config;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mState != 0) {
                throw new StateException("Repository [" + this.getName() + "] is not stopped");
            }
            int destState = 0;
            try {
                this.mState = 4;
                this.getStatus().reset();
                if (!this.cfg.isEnabled()) {
                    throw new ConfigException("Repository [" + this.getName() + "] is not enabled");
                }
                RepositoryEngine newengine = this.cfg.createRepositoryEngine();
                long infDbCacheSize = this.passivateManager.repositoryBecameRunnable(this);
                newengine.setInfDbCacheSize(infDbCacheSize);
                newengine.start();
                this.needsPassivation = false;
                this.engine = newengine;
                this.engine.addListener(new RepositoryListener(){

                    public void onRepositoryUpdate(String repositoryName) {
                        RepositoryHandle.this.eventMulticaster.fireRepositoryUpdate(repositoryName);
                    }
                });
                destState = 1;
            }
            finally {
                this.mState = destState;
            }
            if (this.getEffectivePollPeriod() > 0L) {
                this.pinger.startIncrementalIndexing(2000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEffectivePollPeriod() {
        long pollPeriod = 0L;
        RepositoryEngine eng = null;
        try {
            eng = this.acquire();
            if (!this.isDisableBackgroundUpdaterOnInit()) {
                pollPeriod = eng.getPollPeriod();
            }
        }
        catch (StateException e2) {
        }
        finally {
            if (eng != null) {
                this.release();
            }
        }
        return pollPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryEngine acquireEngine() throws StateException {
        Object object = this.mLock;
        synchronized (object) {
            Disposer disposer = Disposer.threadInstance();
            RepositoryEngine eng = this.acquire();
            disposer.add(new Disposable(){

                public void dispose() {
                    RepositoryHandle.this.release();
                }
            });
            return eng;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RepositoryEngine acquire() throws StateException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mState != 1) {
                throw new StateException("Repository is stopped");
            }
            ++this.mAcquireCount;
            if (Logs.PERF_LOG.isDebugEnabled()) {
                Logs.PERF_LOG.debug((Object)("acquire engine on " + this.getName() + ", count=" + this.mAcquireCount));
            }
            return this.engine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteIndex() throws StateException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mState != 0) {
                throw new StateException("Repository is not stopped");
            }
            RepositoryEngine.deleteCache(this.cfg);
        }
    }

    public RepositoryConfig getCfg() {
        return this.cfg;
    }

    public RepositoryStatus getStatus() {
        return this.cfg.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkForPassivation() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isRunning()) {
                long desiredSize;
                if (this.passivateManager.needsPassivation(this)) {
                    this.needsPassivation = true;
                }
                if ((desiredSize = this.passivateManager.getCacheSize()) != this.engine.getInfDbCacheSize()) {
                    Logs.PERF_LOG.debug((Object)("request passivate (cache resize) on " + this.getName()));
                    this.engine.setInfDbCacheSize(desiredSize);
                    this.needsPassivation = true;
                }
                if (this.needsPassivation && this.mAcquireCount == 0) {
                    Logs.PERF_LOG.debug((Object)("soft passivate (immediate) on " + this.getName()));
                    this.engine.softPassivate();
                    this.needsPassivation = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAcquireCount > 0) {
                --this.mAcquireCount;
            }
            if (Logs.PERF_LOG.isDebugEnabled()) {
                Logs.PERF_LOG.debug((Object)("release engine on " + this.getName() + ", count=" + this.mAcquireCount));
            }
            if (this.mAcquireCount == 0) {
                InfinityDbHandle infDb;
                if (this.needsPassivation) {
                    if (Logs.PERF_LOG.isDebugEnabled()) {
                        Logs.PERF_LOG.debug((Object)("soft passivate (on release) on " + this.getName()));
                    }
                    this.engine.softPassivate();
                    this.needsPassivation = false;
                }
                this.passivateManager.updateOnRelease(this, !(infDb = this.engine.getRevisionCache().getInfDb()).isOpen());
            }
            this.tryToBeginStopProcedure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToBeginStopProcedure() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAcquireCount == 0 && this.mState == 2) {
                try {
                    if (this.engine != null) {
                        Logs.APP_LOG.debug((Object)("STOPPING " + this.name));
                        if (this.pinger != null) {
                            this.pinger.cancel();
                        }
                        this.engine.forceClose();
                    }
                }
                catch (Throwable e2) {
                    Logs.APP_LOG.warn((Object)("problem stopping repository " + this.name), e2);
                }
                finally {
                    this.mState = 0;
                    this.engine = null;
                }
            }
        }
    }

    public void requestCrucibleIncrementalScan() {
        this.pinger.processRequest(new CrucibleIncrementalRequest(this));
    }

    public void requestCrucibleReindex() {
        this.pinger.processRequest(new CrucibleReindexRequest(this));
    }

    public void requestLinecountReindex() {
        this.pinger.processRequest(new LinecountReindexRequest(this));
    }

    public void rescan(String start, String end) {
        this.pinger.processRequest(new RescanRequest(this, start, end));
    }

    public void oneOffScan(boolean synchronous) {
        if (synchronous) {
            final CountDownLatch latch = new CountDownLatch(1);
            this.pinger.processRequest(new OneOffPingRequest(this, new PingRequest.Callback(){

                public void done() {
                    Logs.APP_LOG.debug((Object)"One off scan completed - flipping latch");
                    latch.countDown();
                }
            }));
            try {
                Logs.APP_LOG.debug((Object)"One off scan awaiting latch");
                latch.await();
                Logs.APP_LOG.debug((Object)"One off scan latch done");
            }
            catch (InterruptedException e2) {
                Logs.APP_LOG.warn((Object)"One off scan interrupted");
                throw new RuntimeException("Interupted waiting for one off scan", e2);
            }
        } else {
            this.pinger.processRequest(new OneOffPingRequest(this, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified() {
        if (this.mState == 1) {
            RepositoryEngine eng = this.acquire();
            try {
                long l = Math.max(this.lastModified, eng.getRevisionCache().getLastModifiedDate());
                this.release();
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.release();
                    throw throwable;
                }
                catch (StateException e2) {
                }
                catch (DbException e3) {
                    Logs.APP_LOG.error((Object)("Error calculating last modified date from revision cache for repository " + this.name), (Throwable)e3);
                }
            }
        }
        return this.lastModified;
    }

    public void updateLastModified() {
        this.lastModified = System.currentTimeMillis();
    }

    public String toString() {
        return this.getName();
    }

    public static class StateException
    extends Exception {
        public StateException(String message) {
            super(message);
        }
    }
}

