/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.logging.Logs;
import java.util.Date;

public class RepositoryStatus {
    private volatile String message;
    private volatile String engineError;
    private volatile boolean refreshing;
    private volatile boolean doneFullSlurp;
    private volatile boolean stopRequested;
    private volatile Date lastSlurpTime = null;
    private volatile boolean locReslurpLock;

    public RepositoryStatus() {
        this.reset();
    }

    public void reset() {
        this.message = "";
        this.engineError = "";
        this.refreshing = false;
        this.doneFullSlurp = true;
        this.stopRequested = false;
    }

    public String getMessage() {
        return this.message;
    }

    public String getEngineError() {
        return this.engineError;
    }

    public boolean getEngineHasError() {
        return this.engineError != null && !this.engineError.equals("");
    }

    public boolean isRefreshing() {
        return this.refreshing;
    }

    public boolean isDoneFullSlurp() {
        return this.doneFullSlurp;
    }

    public void setMessage(String message) {
        this.message = message;
        if (message != null && message.length() > 0) {
            Logs.APP_LOG.debug((Object)("Status change: " + message));
        }
    }

    public boolean isMessageAvailable() {
        return this.message != null && this.message.length() > 0;
    }

    public void setEngineError(String engineError) {
        this.engineError = engineError;
    }

    public void setRefreshing(boolean refreshing) {
        this.refreshing = refreshing;
    }

    public void setDoneFullSlurp(boolean doneFullSlurp) {
        this.doneFullSlurp = doneFullSlurp;
    }

    public boolean isStopRequested() {
        return this.stopRequested;
    }

    void setStopRequested(boolean stopRequested) {
        this.stopRequested = stopRequested;
    }

    public Date getLastSlurpTime() {
        return this.lastSlurpTime;
    }

    public void updateLastSlurpTime() {
        this.lastSlurpTime = new Date();
    }

    public synchronized boolean getLocLock() {
        if (this.locReslurpLock) {
            return false;
        }
        this.locReslurpLock = true;
        return true;
    }

    public synchronized void releaseLocLock() {
        this.locReslurpLock = false;
    }
}

