/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.lucene.LuceneHelper;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonFileRevisionInput;
import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;

public class CommonIndexer {
    public static final long MAX_HEAD_BYTES = 0x500000L;

    public void insertNew(IndexWriter idx0, int revid, CommonFileRevisionInput ri) throws DbException {
        try {
            Document doc = new Document();
            doc.add((Fieldable)LuceneHelper.Keyword("revid", Integer.toString(revid)));
            doc.add((Fieldable)LuceneHelper.UnStored("comment", ri.getComment()));
            this.addParentPaths(doc, ri.getPath());
            idx0.addDocument(doc);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void deleteDocumentsForRevid(IndexReader reader, int revid) throws IOException {
        Term t = new Term("revid", Integer.toString(revid));
        reader.deleteDocuments(t);
    }

    public void indexContents(IndexWriter writer, int revid, CommonFileRevisionInput ri, Reader in) throws DbException {
        try {
            Document doc = new Document();
            doc.add((Fieldable)LuceneHelper.Keyword("revid", Integer.toString(revid)));
            this.addParentPaths(doc, ri.getPath());
            Field contents = LuceneHelper.Text("contents", in);
            doc.add((Fieldable)contents);
            writer.addDocument(doc);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void addParentPaths(Document doc, Path path) {
        Path parent = path;
        do {
            parent = parent.getParent();
            doc.add((Fieldable)LuceneHelper.Indexed("parentpaths", parent.getPath()));
        } while (!parent.isRoot());
    }
}

