/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.infinitydb.query3.Query3;
import com.cenqua.fisheye.infinitydb.query3.TermLookupQuery3;
import com.cenqua.fisheye.infinitydb.query3.TermQuery3;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.obfuscate.idbk4ui8v._AndSpace;
import com.cenqua.obfuscate.idbk4ui8v._Cu;
import com.cenqua.obfuscate.idbk4ui8v._EntityClass;
import com.cenqua.obfuscate.idbk4ui8v._ItemSpace;
import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class CommonQuery3Helper {
    public static BooleanQuery findRevisionsUnderDirQuery(Path dir) {
        BooleanQuery query = new BooleanQuery();
        String dirpath = dir == null ? "" : dir.getPath();
        query.add((Query)new TermQuery(new Term("parentpaths", dirpath)), BooleanClause.Occur.MUST);
        return query;
    }

    public static AndQuery3 findRevisionsUnderDirQuery3(Path dir, boolean caseSensitive) {
        AndQuery3 query = new AndQuery3();
        String dirpath = dir == null ? "" : dir.getPath(caseSensitive);
        query.addClause(new TermLookupQuery3(CommonSchema.E_PATHS, CommonSchema.E_PARENTPATHS_TO_REVID, dirpath, null));
        return query;
    }

    public static AndQuery3 findRevisionsInDirQuery3(Path dir, boolean caseSensitive) {
        AndQuery3 query = new AndQuery3();
        String dirpath = dir == null ? "" : dir.getPath(caseSensitive);
        query.addClause(new TermLookupQuery3(CommonSchema.E_PATHS, CommonSchema.E_FULLDIR_TO_REVID, dirpath, null));
        return query;
    }

    public static AndQuery3 findRevisionsAtPathQuery3(Path path, boolean caseSensitive) {
        AndQuery3 query = new AndQuery3();
        String p = path == null ? "" : path.getPath(caseSensitive);
        query.addClause(new TermLookupQuery3(CommonSchema.E_PATHS, CommonSchema.E_PATH_ID_TO_REVID, p, null));
        return query;
    }

    public static Query3 findDeletedRevisionsQuery3() {
        return new TermQuery3(CommonSchema.E_ISDELETED_TO_REVID, _Cu.alloc(), null);
    }

    public static Query3 findTrunkLikeRevisionQuery() {
        return new TermQuery3(CommonSchema.E_ISTRUNKLIKE_TO_REVID, _Cu.alloc(), null);
    }

    public static void visitMatchingStringTerms(_ItemSpace db, Query3 q, _EntityClass entity, StringVisitor v) throws DbException {
        try {
            LuceneConnection conn = null;
            _ItemSpace constraint = q.asItemSpace(db, conn);
            _Cu cu2 = _Cu.alloc();
            _Cu cu = _Cu.alloc();
            cu.append(entity);
            int pl = cu.length();
            while (db.next(cu, pl)) {
                boolean cont;
                String term = cu.stringAt(pl);
                int p2 = cu.skipString(pl);
                cu.setLength(p2).appendInfinity();
                TermQuery3 termq = new TermQuery3(entity, term, null);
                _AndSpace termspace = new _AndSpace();
                termspace.add(constraint);
                termspace.add(termq.asItemSpace(db, conn));
                cu2.clear();
                if (!termspace.next(cu2) || (cont = v.visit(term))) continue;
                break;
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public static interface StringVisitor {
        public boolean visit(String var1);
    }
}

