/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.ping;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.ping.PingRequest;
import com.cenqua.fisheye.util.Disposer;

public class OneOffPingRequest
extends PingRequest {
    public OneOffPingRequest(RepositoryHandle handle, PingRequest.Callback callback) {
        super(handle, 1, callback);
    }

    protected OneOffPingRequest(RepositoryHandle handle, int priority, PingRequest.Callback callback) {
        super(handle, priority, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRequest() {
        RepositoryHandle handle = this.getHandle();
        if (handle.isRunning()) {
            Disposer.pushThreadInstance();
            try {
                boolean skipCruIncremental = handle.getStatus().isDoneFullSlurp();
                RepositoryEngine eng = handle.acquireEngine();
                eng.doSlurp();
                if (AppConfig.isCrucible() && !skipCruIncremental && HibernateUtil.isRunning() && !handle.getStatus().isStopRequested()) {
                    eng.doReviewSlurp(false);
                }
            }
            catch (Throwable e2) {
                Logs.APP_LOG.error((Object)"Exception during slurp", e2);
            }
            finally {
                Disposer.popThreadInstance();
            }
        }
    }

    public String getDescription() {
        return "FishEye One-off Indexing";
    }
}

