/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.diff;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.io.ReaderLineReader;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.svn.diff.SvnDiffListener;
import com.cenqua.fisheye.svn.diff.SvnDiffParsingException;
import com.cenqua.fisheye.util.diff.SectionSpec;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnDiffParser {
    private ReaderLineReader reader;
    private SvnDiffListener listener;
    private String readAhead = null;
    private long revision;
    private File diffFile;
    private Path contextPath;
    private static final Map<String, Map<String, Pattern>> localePatterns = new HashMap<String, Map<String, Pattern>>();
    private static final String INDEX_KEY = "index";
    private static final String PROPCHANGE_KEY = "propchange";
    private static final String NONDISPLAY_KEY = "nondisplay";
    private static final String FROM_KEY = "fromheader";
    private static final String TO_KEY = "toheader";
    private static final String PROPNAME_KEY = "name";
    private static final String PROP_ADD_KEY = "propAdd";
    private static final String PROP_DEL_KEY = "propDel";
    private static final String PROP_MERGINFO_KEY = "propMerge";
    private static final String[] KEYS = new String[]{"index", "propchange", "nondisplay", "fromheader", "toheader", "name", "propAdd", "propDel", "propMerge"};
    private Map<String, Pattern> patternMap;
    private static final Map<String, Pattern> defaultMap = new HashMap<String, Pattern>();
    private static final String REGEX_BUNDLE = "com.cenqua.fisheye.svn.diff.DiffRegex";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SvnDiffParser(Locale locale) {
        String localeKey = locale.toString();
        Map<String, Map<String, Pattern>> map = localePatterns;
        synchronized (map) {
            if (!localePatterns.containsKey(localeKey)) {
                Map<String, Pattern> patterns;
                ResourceBundle bundle = ResourceBundle.getBundle(REGEX_BUNDLE, locale);
                if (bundle.getLocale().getLanguage().equals("")) {
                    patterns = defaultMap;
                } else {
                    patterns = new HashMap<String, Pattern>();
                    SvnDiffParser.loadBundleMap(bundle, patterns);
                }
                localePatterns.put(localeKey, patterns);
            }
        }
        this.patternMap = localePatterns.get(localeKey);
    }

    private static void loadBundleMap(ResourceBundle bundle, Map<String, Pattern> patterns) {
        for (String key : KEYS) {
            String patternString = bundle.getString(key);
            Pattern pattern = Pattern.compile(patternString);
            patterns.put(key, pattern);
        }
    }

    public void setContext(File diffFile, long revision) {
        this.revision = revision;
        this.diffFile = diffFile;
    }

    public void setContextPath(Path path) {
        this.contextPath = path;
    }

    private Matcher matches(String text, String patternKey) {
        Matcher matcher = this.matchPattern(this.patternMap, patternKey, text);
        if (matcher == null && this.patternMap != defaultMap) {
            matcher = this.matchPattern(defaultMap, patternKey, text);
        }
        return matcher;
    }

    private Matcher matchPattern(Map<String, Pattern> patternMap, String patternKey, String text) {
        Matcher matcher = null;
        Pattern pattern = patternMap.get(patternKey);
        if (pattern != null && !(matcher = pattern.matcher(text)).find()) {
            matcher = null;
        }
        return matcher;
    }

    private String readLine() throws IOException {
        String result;
        if (this.readAhead != null) {
            result = this.readAhead;
            this.readAhead = null;
        } else {
            result = this.reader.readLine(1000);
        }
        return result;
    }

    private void pushBack(String data) {
        this.readAhead = data;
    }

    private void reportError(Throwable e2) throws SvnDiffParsingException {
        if (e2 instanceof SvnDiffParsingException) {
            throw (SvnDiffParsingException)e2;
        }
        String message = e2.getClass().toString() + ":" + e2.getMessage();
        Logs.APP_LOG.error((Object)("Error processing diff " + (this.revision - 1L) + ":" + this.revision + " in " + this.diffFile + " - " + message));
        throw new SvnDiffParsingException(message, e2);
    }

    private void reportError(String message) throws SvnDiffParsingException {
        Logs.APP_LOG.error((Object)("Error processing diff " + (this.revision - 1L) + ":" + this.revision + " in " + this.diffFile + " - " + message));
        throw new SvnDiffParsingException(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ReaderLineReader reader, SvnDiffListener listener) throws SvnDiffParsingException {
        this.reader = reader;
        this.listener = listener;
        try {
            String line;
            while ((line = this.readLine()) != null) {
                Matcher matcher = this.matches(line, INDEX_KEY);
                if (matcher != null) {
                    this.processFileChange(matcher.group(1));
                    continue;
                }
                matcher = this.matches(line, PROPCHANGE_KEY);
                if (matcher != null) {
                    this.processPropertyChange(matcher.group(1));
                    continue;
                }
                if (line.trim().length() == 0) continue;
                this.reportError("Unexpected line in overall diff, line = [" + line + "]");
            }
        }
        catch (Exception e2) {
            this.reportError(e2);
        }
        finally {
            this.readAhead = null;
        }
    }

    private void processFileChange(String indexPath) throws IOException {
        String line;
        Path path = this.getPath(indexPath);
        this.listener.indexMark(path);
        this.reader.readLine();
        while ((line = this.readLine()) != null) {
            if (this.matches(line, FROM_KEY) != null) {
                this.listener.fromHeader(path, line.substring(4));
                continue;
            }
            if (this.matches(line, TO_KEY) != null) {
                this.listener.toHeader(path, line.substring(4));
                continue;
            }
            if (this.matches(line, NONDISPLAY_KEY) != null) {
                this.reader.readLine();
                continue;
            }
            if (SectionSpec.isValidSection(line)) {
                this.processSection(path, line);
                continue;
            }
            if (line.trim().length() == 0 || this.matches(line, INDEX_KEY) == null && this.matches(line, PROPCHANGE_KEY) == null) continue;
            this.pushBack(line);
            break;
        }
        this.listener.endFile();
    }

    private Path getPath(String indexLine) {
        Path path = this.contextPath == null ? new Path(indexLine.replace('\\', '/')) : new Path(this.contextPath, indexLine.replace('\\', '/'));
        return path;
    }

    private String readPropertyValue(String startLine) throws IOException {
        String line;
        StringBuffer buffer = new StringBuffer(startLine.substring(5));
        while ((line = this.readLine()) != null) {
            if (this.matches(line, PROP_ADD_KEY) != null || this.matches(line, PROP_DEL_KEY) != null || this.matches(line, PROPNAME_KEY) != null || this.matches(line, INDEX_KEY) != null || this.matches(line, PROPCHANGE_KEY) != null) {
                this.pushBack(line);
                break;
            }
            buffer.append("\n");
            buffer.append(line);
        }
        return buffer.toString().trim();
    }

    private void processPropertyChange(String propertyPath) throws IOException {
        String line;
        Path path = this.getPath(propertyPath);
        this.listener.propertyIndexMark(path);
        this.reader.readLine();
        String propertyName = null;
        while ((line = this.readLine()) != null) {
            Matcher matcher = this.matches(line, PROPNAME_KEY);
            if (matcher != null) {
                propertyName = matcher.group(2);
                continue;
            }
            if (this.matches(line, PROP_ADD_KEY) != null) {
                this.listener.updateProperty(path, propertyName, this.readPropertyValue(line));
                continue;
            }
            if (this.matches(line, PROP_DEL_KEY) != null) {
                this.listener.removeProperty(path, propertyName, this.readPropertyValue(line));
                continue;
            }
            if (this.matches(line, PROP_MERGINFO_KEY) != null) {
                this.listener.updateProperty(path, propertyName, this.readPropertyValue(line));
                continue;
            }
            this.pushBack(line);
            return;
        }
    }

    private void processSection(Path path, String sectionLine) throws IOException {
        String line;
        SectionSpec spec = new SectionSpec(sectionLine);
        this.listener.section(path, spec);
        int toCount = 0;
        int fromCount = 0;
        while ((line = this.readLine()) != null) {
            if (line.startsWith("+")) {
                this.listener.addLine(path, line.substring(1));
                ++toCount;
                continue;
            }
            if (line.startsWith("-")) {
                this.listener.removeLine(path, line.substring(1));
                ++fromCount;
                continue;
            }
            if (line.startsWith(" ")) {
                this.listener.contextLine(path, line.substring(1));
                ++toCount;
                ++fromCount;
                continue;
            }
            if (line.startsWith("\\") || (fromCount != spec.getFromCount() || toCount != spec.getToCount()) && fromCount <= spec.getFromCount() && toCount <= spec.getToCount()) continue;
            this.pushBack(line);
            break;
        }
        this.listener.endSection();
    }

    static {
        ResourceBundle defaultBundle = ResourceBundle.getBundle(REGEX_BUNDLE, new Locale(""));
        SvnDiffParser.loadBundleMap(defaultBundle, defaultMap);
        localePatterns.put(Locale.US.toString(), defaultMap);
    }
}

