/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.util;

import java.io.UnsupportedEncodingException;

public class SvnURLDecoder {
    static String dfltEncName = System.getProperty("file.encoding");

    public static String decode(String s) {
        String str = null;
        try {
            str = SvnURLDecoder.decode(s, dfltEncName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str;
    }

    public static String decode(String s, String enc) throws UnsupportedEncodingException {
        boolean needToChange = false;
        int numChars = s.length();
        StringBuffer sb = new StringBuffer(numChars > 500 ? numChars / 2 : numChars);
        int i2 = 0;
        if (enc.length() == 0) {
            throw new UnsupportedEncodingException("URLDecoder: empty string enc parameter");
        }
        byte[] bytes = null;
        block5: while (i2 < numChars) {
            char c2 = s.charAt(i2);
            switch (c2) {
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i2) / 3];
                        }
                        int pos = 0;
                        while (i2 + 2 < numChars && c2 == '%') {
                            bytes[pos++] = (byte)Integer.parseInt(s.substring(i2 + 1, i2 + 3), 16);
                            if ((i2 += 3) >= numChars) continue;
                            c2 = s.charAt(i2);
                        }
                        if (i2 < numChars && c2 == '%') {
                            throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                        }
                        sb.append(new String(bytes, 0, pos, enc));
                    }
                    catch (NumberFormatException e2) {
                        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - " + e2.getMessage());
                    }
                    needToChange = true;
                    continue block5;
                }
            }
            sb.append(c2);
            ++i2;
        }
        return needToChange ? sb.toString() : s;
    }
}

