/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.syntax.InputState;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.util.VariableSubstituter;
import java.util.HashMap;
import java.util.Map;

public class RegionGenerator {
    private String submatchRef = "0";
    private Map properties = new HashMap();

    public String getSubmatchRef() {
        return this.submatchRef;
    }

    public void setSubmatchRef(String submatchRef) {
        this.submatchRef = submatchRef;
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void generate(InputState input, Map matchRegions, RegionList outputRegions) {
        Region region = (Region)matchRegions.get(this.submatchRef);
        if (region != null) {
            outputRegions.add(new Region(region, this.processPropertyValues(input, matchRegions)));
        }
    }

    private Map processPropertyValues(InputState input, Map matchRegions) {
        HashMap<String, String> newprops = new HashMap<String, String>();
        for (String key : this.properties.keySet()) {
            String val = (String)this.properties.get(key);
            newprops.put(key, this.substituteRefs(input, val, matchRegions));
        }
        return newprops;
    }

    private String substituteRefs(final InputState input, String val, final Map matchRegions) {
        return VariableSubstituter.substituteRefs((CharSequence)val, new VariableSubstituter.VariableMap(){

            public CharSequence map(String variable) {
                Region region = (Region)matchRegions.get(variable);
                return region == null ? null : input.getSubSequence(region);
            }
        });
    }

    public String toString() {
        String res = "RegionGenerator{submatch=" + this.submatchRef + ";props={";
        String sep = "";
        for (String key : this.properties.keySet()) {
            String val = (String)this.properties.get(key);
            res = res + sep + key + "=" + val;
            sep = ",";
        }
        res = res + "}}";
        return res;
    }
}

