/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.cenqua.fisheye.config1.CustomRepositoryConfigType;
import com.cenqua.fisheye.config1.CustomSecurityConfigType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.BaseAuth;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.plugin.AuthToken;
import com.cenqua.fisheye.user.plugin.FishEyeAuthenticator;
import com.cenqua.fisheye.user.plugin.NullFishEyeAuthenticator;
import com.cenqua.fisheye.util.PropertiesUtil;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class CustomAuth
extends BaseAuth {
    private final boolean autoAdd;
    private final FishEyeAuthenticator mPlugin;

    public CustomAuth(CustomSecurityConfigType cfg) {
        this(cfg, Logs.APP_LOG, Logs.PERF_LOG);
    }

    public CustomAuth(CustomSecurityConfigType cfg, Logger appLog, Logger perfLog) {
        super(appLog, perfLog);
        this.autoAdd = cfg.getAutoAdd();
        this.setPermCacheTTL(cfg.getPositiveCacheTtl());
        String classname = cfg.getClassname();
        Properties p = new Properties();
        if (cfg.isSetProperties()) {
            PropertiesUtil.loadFromString(p, cfg.getProperties());
        }
        FishEyeAuthenticator plugin = null;
        try {
            Class<?> clazz;
            Object o;
            ClassLoader parent = this.getClass().getClassLoader();
            if (parent == null) {
                parent = ClassLoader.getSystemClassLoader();
            }
            if ((o = (clazz = parent.loadClass(classname)).newInstance()) instanceof FishEyeAuthenticator) {
                plugin = (FishEyeAuthenticator)o;
                try {
                    plugin.init(p);
                }
                catch (Exception e2) {
                    plugin = null;
                    appLog.error((Object)"Error calling init() on the custom authenticator", (Throwable)e2);
                }
            } else {
                appLog.error((Object)("The custom authenticator you supplied (" + classname + ") does not implement " + FishEyeAuthenticator.class.getName()));
            }
        }
        catch (ClassNotFoundException e3) {
            appLog.error((Object)"Could not find your custom authenticator", (Throwable)e3);
        }
        catch (Exception e4) {
            appLog.error((Object)"Problem creating your custom authenticator", (Throwable)e4);
        }
        if (plugin == null) {
            appLog.error((Object)"Could not create your custom authenticator, it will not be used.");
            plugin = new NullFishEyeAuthenticator();
        }
        this.mPlugin = plugin;
    }

    public void close() {
        this.mPlugin.close();
    }

    public boolean getAutoAdd() {
        return this.autoAdd;
    }

    public int getAuthType() {
        return 4;
    }

    public BaseAuth.AuthTok checkPassword(String username, String password, HttpServletRequest request, HttpServletResponse response) {
        long t0 = System.currentTimeMillis();
        AuthToken tok = this.mPlugin.checkPassword(username, password);
        long t1 = System.currentTimeMillis();
        if (this.perfLog.isInfoEnabled()) {
            this.perfLog.info((Object)("custom password check for " + username + " in " + (t1 - t0) + "ms"));
        }
        return tok == null ? null : new CustomAuthTok(tok);
    }

    public BaseAuth.AuthTok recreateAuth(String username) {
        AuthToken tok = this.mPlugin.recreateAuth(username);
        return tok == null ? null : new CustomAuthTok(tok);
    }

    public boolean hasPermissionToAccess(BaseAuth.AuthTok atok, boolean defaultResult, RepositoryHandle rcfg) {
        if (!(atok instanceof CustomAuthTok)) {
            return false;
        }
        CustomAuthTok tok = (CustomAuthTok)atok;
        AuthToken token = tok.tok;
        CustomRepositoryConfigType constraint = rcfg.getCfg().getCustomAuthConstraint();
        String constraintString = constraint == null ? null : constraint.getConstraint();
        String repname = rcfg.getName();
        Boolean cacheResult = this.checkCache(tok, repname);
        if (cacheResult != null) {
            if (this.appLog.isDebugEnabled()) {
                this.appLog.debug((Object)("CUSTOMAUTH: got perm check from the cache, " + token.getUsername() + " against rep " + repname));
            }
            return cacheResult;
        }
        boolean result = this.mPlugin.hasPermissionToAccess(token, repname, constraintString);
        this.setCache(tok, repname, result);
        return result;
    }

    public BaseAuth.AuthTok checkRequest(HttpServletRequest request, HttpServletResponse response) {
        AuthToken tok = this.mPlugin.checkRequest(request);
        return tok == null ? null : new CustomAuthTok(tok);
    }

    protected boolean isRequestUserStillValid(UserLogin user, BaseAuth.AuthTok authTok, HttpServletRequest req, HttpServletResponse response) {
        return this.mPlugin.isRequestUserStillValid(user.getUsername(), req);
    }

    private static class CustomAuthTok
    extends BaseAuth.AuthTok {
        final AuthToken tok;

        public CustomAuthTok(AuthToken tok) {
            this.tok = tok;
        }

        public String getEmail() {
            return this.tok.getEmail();
        }

        public String getUsername() {
            return this.tok.getUsername();
        }

        public String getDisplayName() {
            return this.tok.getDisplayName();
        }

        public int getAuthType() {
            return 4;
        }
    }
}

