/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.cenqua.fisheye.user.LoginCookieToken;
import com.cenqua.fisheye.web.ServletUtils;
import javax.servlet.http.HttpServletRequest;

public class LoginCookie
extends LoginCookieToken {
    public static final int REMEMBER_ME = 1;
    public static final int PRECOOKED_URL = 2;
    private final long createDate;
    private final int type;
    private final String url;
    private final boolean recursiveUrl;

    public LoginCookie(long loginId, String username, String rnd, long createDate, int type) {
        this(loginId, username, rnd, createDate, type, null, false);
    }

    public LoginCookie(long loginId, String username, String rnd, long createDate, int type, String url, boolean recursiveUrl) {
        super(loginId, username, rnd);
        this.createDate = createDate;
        this.type = type;
        this.url = url;
        this.recursiveUrl = recursiveUrl;
    }

    public void setRnd(String rnd) {
        this.rnd = rnd;
    }

    public long getCreateDate() {
        return this.createDate;
    }

    public int getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isRecursiveUrl() {
        return this.recursiveUrl;
    }

    public boolean matches(LoginCookieToken given, HttpServletRequest req) {
        boolean success;
        boolean bl = success = this.getLoginId() == given.getLoginId() && this.getUsername().equals(given.getUsername()) && this.getRnd().equals(given.getRnd());
        if (!success) {
            return false;
        }
        if (this.getType() == 2) {
            String u = ServletUtils.getOriginalPostContextPath(req);
            success = this.isRecursiveUrl() ? u.startsWith(this.getUrl()) : u.equals(this.getUrl());
        }
        return success;
    }
}

