/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user.crowd;

import com.cenqua.fisheye.logging.Logs;
import java.util.HashMap;
import java.util.Map;

class GroupMembershipCache {
    private final Map<String, Node> map = new HashMap<String, Node>();
    private final long ttl;

    GroupMembershipCache(long ttl) {
        this.ttl = ttl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, Node> map = this.map;
        synchronized (map) {
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] groupsForUser(String username) {
        Map<String, Node> map = this.map;
        synchronized (map) {
            Node node = this.map.get(username);
            if (node == null) {
                return null;
            }
            if (node.timeUpdated + this.ttl < System.currentTimeMillis()) {
                this.map.remove(username);
                Logs.PERF_LOG.debug((Object)("expired group cache for " + username));
                return null;
            }
            return node.groups;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatesGroupsForUser(String username, String[] groups) {
        Map<String, Node> map = this.map;
        synchronized (map) {
            this.map.put(username, new Node(groups, System.currentTimeMillis()));
            if (Logs.PERF_LOG.isDebugEnabled()) {
                Logs.PERF_LOG.debug((Object)("cache groups for " + username));
            }
        }
    }

    private static class Node {
        public final String[] groups;
        public final long timeUpdated;

        public Node(String[] groups, long timeUpdated) {
            this.groups = groups;
            this.timeUpdated = timeUpdated;
        }
    }
}

