/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import antlr.Token;
import antlr.TokenStreamException;
import com.cenqua.fisheye.cvsrep.search.query.QueryLangLexer;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.TimeZone;

public class DateHelper {
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT+0");
    public static LinkedHashSet AVAILABLE_TIMEZONE_IDS = new LinkedHashSet();
    private static final SimpleDateFormat standardGmtDateFormat = new SimpleDateFormat("d MMM yyyy HH:mm:ss 'GMT'", Locale.ENGLISH);

    public static String age(long birth, long now) {
        long dDaysRemainder;
        long dSecs;
        if (now < birth) {
            long tmp = now;
            now = birth;
            birth = tmp;
        }
        if ((dSecs = (now - birth) / 1000L) < 120L) {
            return DateHelper.durationToString(dSecs, "second");
        }
        long dMins = dSecs / 60L;
        if (dMins < 120L) {
            return DateHelper.durationToString(dMins, "minute");
        }
        long dHours = dMins / 60L;
        if (dHours < 72L) {
            return DateHelper.durationToString(dHours, "hour");
        }
        long dDays = dHours / 24L;
        if (dDays < 60L) {
            return DateHelper.durationToString(dDays, "day");
        }
        double dYearsVal = (double)dDays / 365.242199;
        double dMonthsVal = dYearsVal * 12.0;
        long dMonths = (long)dMonthsVal;
        if (dMonths < 6L && (dDaysRemainder = (long)((dMonthsVal - (double)dMonths) * 30.4368499)) != 0L) {
            return DateHelper.durationToString(dMonths, "month") + " " + DateHelper.durationToString(dDaysRemainder, "day");
        }
        if (dMonths < 24L) {
            return DateHelper.durationToString(dMonths, "month");
        }
        long dYears = (long)dYearsVal;
        long dMonthsRemainder = dMonths % 12L;
        if (dMonthsRemainder == 0L) {
            return DateHelper.durationToString(dYears, "year");
        }
        return DateHelper.durationToString(dYears, "year") + " " + DateHelper.durationToString(dMonthsRemainder, "month");
    }

    private static String durationToString(long dur, String unit) {
        if (dur == 1L) {
            return dur + " " + unit;
        }
        return dur + " " + unit + "s";
    }

    public static int[] timeToComponents(long time) {
        GregorianCalendar date = new GregorianCalendar(GMT);
        date.setTimeInMillis(time);
        int[] components = new int[]{date.get(1), date.get(2) + 1, date.get(5), date.get(11), date.get(12), date.get(13)};
        return components;
    }

    public static long componentsToTime(int[] components) {
        return DateHelper.componentsToTime(components[0], components[1], components[2], components[3], components[4], components[5]);
    }

    public static long componentsToTime(int year, int month, int day, int hour, int min, int sec) {
        return DateHelper.componentsToTime(year, month, day, hour, min, sec, GMT);
    }

    public static long componentsToTime(int year, int month, int day, int hour, int min, int sec, TimeZone tz) {
        GregorianCalendar date = new GregorianCalendar(tz);
        date.set(14, 0);
        date.set(year, month - 1, day, hour, min, sec);
        long ms = date.getTimeInMillis();
        return ms / 1000L * 1000L;
    }

    public static Long parseDate(String date, long now, TimeZone tz) {
        Token token;
        if (date == null || date.length() == 0) {
            return null;
        }
        QueryLangLexer lexer = new QueryLangLexer(new StringReader(date));
        lexer.now = now;
        lexer.timezone = tz;
        try {
            token = lexer.nextToken();
        }
        catch (TokenStreamException e2) {
            return null;
        }
        if (token.getType() != 75) {
            return null;
        }
        QueryLangLexer.DateToken dt = (QueryLangLexer.DateToken)token;
        return dt.date;
    }

    public static GregorianCalendar timeAsCalendar(long date, TimeZone tz) {
        GregorianCalendar cal = new GregorianCalendar(tz);
        cal.setTimeInMillis(date);
        return cal;
    }

    public static Date getEndOfDay(Date day, TimeZone tz) {
        GregorianCalendar cal = new GregorianCalendar(tz);
        cal.setTime(day);
        cal.set(11, ((Calendar)cal).getMaximum(11));
        cal.set(12, ((Calendar)cal).getMaximum(12));
        cal.set(13, ((Calendar)cal).getMaximum(13));
        cal.set(14, ((Calendar)cal).getMaximum(14));
        return cal.getTime();
    }

    public static Date getStartOfDay(Date day, TimeZone tz) {
        GregorianCalendar cal = new GregorianCalendar(tz);
        cal.setTime(day);
        cal.set(11, ((Calendar)cal).getMinimum(11));
        cal.set(12, ((Calendar)cal).getMinimum(12));
        cal.set(13, ((Calendar)cal).getMinimum(13));
        cal.set(14, ((Calendar)cal).getMinimum(14));
        return cal.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toGmtString(Date date) {
        SimpleDateFormat simpleDateFormat = standardGmtDateFormat;
        synchronized (simpleDateFormat) {
            return standardGmtDateFormat.format(date);
        }
    }

    public static GregorianCalendar getStartOfTodayAsCalendar(TimeZone tz) {
        GregorianCalendar cal = new GregorianCalendar(tz);
        cal.set(11, cal.getMinimum(11));
        cal.set(12, cal.getMinimum(12));
        cal.set(13, cal.getMinimum(13));
        cal.set(14, cal.getMinimum(14));
        return cal;
    }

    static {
        Object[] ids = TimeZone.getAvailableIDs();
        Arrays.sort(ids);
        AVAILABLE_TIMEZONE_IDS.addAll(Arrays.asList(ids));
        standardGmtDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

