/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.Path;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class HierarchicalPathCollector {
    private final List mPaths = new LinkedList();
    private final SortedMap mDirs = new TreeMap();

    public void add(Path p) {
        this.mPaths.add(p);
        Path dir = p.getParent();
        LinkedList<Path> dirList = (LinkedList<Path>)this.mDirs.get(dir);
        if (dirList == null) {
            dirList = new LinkedList<Path>();
            this.mDirs.put(dir, dirList);
        }
        dirList.add(p);
    }

    public void addAll(Collection paths) {
        for (Path path : paths) {
            this.add(path);
        }
    }

    public List getPaths() {
        return this.mPaths;
    }

    public Map getDirectoryMap() {
        return this.mDirs;
    }
}

