/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiMap<K, V> {
    private final Map<K, List<V>> mMap;

    public MultiMap(Map<K, List<V>> map) {
        this.mMap = map;
    }

    public MultiMap() {
        this.mMap = new HashMap<K, List<V>>();
    }

    public V getFirst(K key) {
        List<V> l = this.getList(key);
        if (l == null || l.isEmpty()) {
            return null;
        }
        return l.get(0);
    }

    public List<V> getList(K key) {
        return this.mMap.get(key);
    }

    public Map<K, List<V>> map() {
        return this.mMap;
    }

    public Set<K> keySet() {
        return this.mMap.keySet();
    }

    public void add(K key, V value) {
        List<V> l = this.mMap.get(key);
        if (l == null) {
            l = new ArrayList<V>();
            this.mMap.put(key, l);
        }
        l.add(value);
    }

    public List<V> remove(K key) {
        return this.mMap.remove(key);
    }

    public void addAll(Map<K, V> totals) {
        for (Map.Entry<K, V> e2 : totals.entrySet()) {
            this.add(e2.getKey(), e2.getValue());
        }
    }

    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    public Iterator<V> iterator() {
        return new Iterator<V>(){
            Iterator<V> listIterator;
            Iterator<List<V>> mapIterator;
            {
                this.mapIterator = MultiMap.this.mMap.values().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.listIterator != null && this.listIterator.hasNext()) {
                    return true;
                }
                while (this.mapIterator.hasNext()) {
                    List nextList = this.mapIterator.next();
                    this.listIterator = nextList.iterator();
                    if (!this.listIterator.hasNext()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public V next() {
                if (this.hasNext()) {
                    return this.listIterator.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean containsKey(K key) {
        return this.mMap.containsKey(key);
    }

    public Collection<V> values() {
        ArrayList<V> values = new ArrayList<V>();
        Iterator<V> i2 = this.iterator();
        while (i2.hasNext()) {
            V o = i2.next();
            values.add(o);
        }
        return values;
    }

    public int size() {
        int size = 0;
        for (List<V> list : this.mMap.values()) {
            size += list.size();
        }
        return size;
    }
}

